/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.ispn;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.ha.framework.server.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.ha.framework.server.lock.TimeoutException;
import org.jboss.ha.ispn.invoker.CacheInvoker;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.impl.IncomingDistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.CacheSource;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionAttributeStorage;
import org.jboss.web.tomcat.service.session.distributedcache.ispn.SessionMapEntry;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionOwnershipSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class DistributedCacheManager<T extends OutgoingDistributableSessionData>
implements org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager<T>,
SessionOwnershipSupport {
    static final Logger log = Logger.getLogger(DistributedCacheManager.class);
    private static final Random random = new Random();
    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> lockResultMap = DistributedCacheManager.lockResultMap();
    final SessionAttributeStorage<T> attributeStorage;
    private final LocalDistributableSessionManager manager;
    private final SharedLocalYieldingClusterLockManager lockManager;
    private final Cache<String, Map<Object, Object>> sessionCache;
    private final CacheInvoker invoker;
    private final BatchingManager batchingManager;
    private final boolean passivationEnabled;
    private final JvmRouteHandler jvmRouteHandler;

    static String mask(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        int length = sessionId.length();
        if (length <= 8) {
            return sessionId;
        }
        return sessionId.substring(0, 2) + "****" + sessionId.substring(length - 6, length);
    }

    static RuntimeException getRuntimeException(String message, Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(message != null ? message : e.toString(), e);
    }

    private static Map<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> lockResultMap() {
        EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult> map = new EnumMap<SharedLocalYieldingClusterLockManager.LockResult, SessionOwnershipSupport.LockResult>(SharedLocalYieldingClusterLockManager.LockResult.class);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ACQUIRED_FROM_CLUSTER, SessionOwnershipSupport.LockResult.ACQUIRED_FROM_CLUSTER);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.ALREADY_HELD, SessionOwnershipSupport.LockResult.ALREADY_HELD);
        map.put(SharedLocalYieldingClusterLockManager.LockResult.NEW_LOCK, SessionOwnershipSupport.LockResult.NEW_LOCK);
        return map;
    }

    public DistributedCacheManager(LocalDistributableSessionManager manager, Cache<String, Map<Object, Object>> sessionCache, CacheSource jvmRouteCacheSource, SharedLocalYieldingClusterLockManager lockManager, SessionAttributeStorage<T> attributeStorage, BatchingManager batchingManager, CacheInvoker invoker) {
        this.manager = manager;
        this.lockManager = lockManager;
        this.sessionCache = sessionCache;
        this.attributeStorage = attributeStorage;
        this.batchingManager = batchingManager;
        this.invoker = invoker;
        Configuration configuration = this.sessionCache.getConfiguration();
        CacheLoaderManagerConfig loaderManagerConfig = configuration.getCacheLoaderManagerConfig();
        this.passivationEnabled = loaderManagerConfig != null ? loaderManagerConfig.isPassivation().booleanValue() && !loaderManagerConfig.isShared().booleanValue() : false;
        this.jvmRouteHandler = configuration.getCacheMode().isDistributed() ? new JvmRouteHandler(jvmRouteCacheSource, this.manager) : null;
    }

    public void start() {
        if (!this.sessionCache.getStatus().allowInvocations()) {
            this.sessionCache.start();
        }
        this.sessionCache.addListener((Object)this);
        if (this.jvmRouteHandler != null) {
            EmbeddedCacheManager container = (EmbeddedCacheManager)this.sessionCache.getCacheManager();
            container.addListener((Object)this.jvmRouteHandler);
            String jvmRoute = this.manager.getJvmRoute();
            if (jvmRoute != null) {
                this.jvmRouteHandler.getCache().putIfAbsent((Object)container.getAddress(), (Object)jvmRoute);
            }
        }
    }

    public void stop() {
        if (this.jvmRouteHandler != null) {
            EmbeddedCacheManager container = (EmbeddedCacheManager)this.sessionCache.getCacheManager();
            container.removeListener((Object)this.jvmRouteHandler);
        }
        this.sessionCache.removeListener((Object)this);
        this.sessionCache.stop();
    }

    public BatchingManager getBatchingManager() {
        return this.batchingManager;
    }

    public void sessionCreated(String sessionId) {
        DistributedCacheManager.trace("sessionCreated(%s)", sessionId);
    }

    public void storeSessionData(final T sessionData) {
        final String sessionId = sessionData.getRealId();
        DistributedCacheManager.trace("storeSessionData(%s)", sessionId);
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, Map<Object, Object>> cache) {
                Map map = (Map)cache.putIfAbsent((Object)sessionId, null);
                SessionMapEntry.VERSION.put(map, sessionData.getVersion());
                SessionMapEntry.METADATA.put(map, sessionData.getMetadata());
                SessionMapEntry.TIMESTAMP.put(map, sessionData.getTimestamp());
                DistributedCacheManager.this.attributeStorage.store(map, sessionData);
                return null;
            }
        };
        this.batch(operation);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, boolean initialLoad) {
        DistributedCacheManager.trace("getSessionData(%s, %s)", sessionId, initialLoad);
        return this.getData(sessionId, true);
    }

    public IncomingDistributableSessionData getSessionData(String sessionId, String dataOwner, boolean includeAttributes) {
        DistributedCacheManager.trace("getSessionData(%s, %s, %s)", sessionId, dataOwner, includeAttributes);
        return dataOwner == null ? this.getData(sessionId, includeAttributes) : null;
    }

    private IncomingDistributableSessionData getData(final String sessionId, final boolean includeAttributes) {
        Operation<IncomingDistributableSessionData> operation = new Operation<IncomingDistributableSessionData>(){

            public IncomingDistributableSessionData invoke(Cache<String, Map<Object, Object>> cache) {
                Map map = (Map)cache.get((Object)sessionId);
                if (map == null) {
                    return null;
                }
                Integer version = (Integer)SessionMapEntry.VERSION.get(map);
                Long timestamp = (Long)SessionMapEntry.TIMESTAMP.get(map);
                DistributableSessionMetadata metadata = (DistributableSessionMetadata)SessionMapEntry.METADATA.get(map);
                IncomingDistributableSessionDataImpl result = new IncomingDistributableSessionDataImpl(version, timestamp, metadata);
                if (includeAttributes) {
                    try {
                        result.setSessionAttributes(DistributedCacheManager.this.attributeStorage.load(map));
                    }
                    catch (Exception e) {
                        throw DistributedCacheManager.getRuntimeException("Failed to load session attributes for session: " + DistributedCacheManager.mask(sessionId), e);
                    }
                }
                return result;
            }
        };
        try {
            return (IncomingDistributableSessionData)this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)operation);
        }
        catch (Exception e) {
            String message = String.format("Problem accessing session [%s]: %s", DistributedCacheManager.mask(sessionId), e.toString());
            log.warn((Object)message);
            log.debug((Object)message, (Throwable)e);
            this.removeSessionLocal(sessionId);
            return null;
        }
    }

    public void removeSession(String sessionId) {
        DistributedCacheManager.trace("removeSession(%s)", sessionId);
        this.removeSession(sessionId, false);
    }

    public void removeSessionLocal(String sessionId) {
        DistributedCacheManager.trace("removeSessionLocal(%s)", sessionId);
        this.removeSession(sessionId, true);
    }

    private void removeSession(final String sessionId, final boolean local) {
        Operation<Map<Object, Object>> operation = new Operation<Map<Object, Object>>(){

            public Map<Object, Object> invoke(Cache<String, Map<Object, Object>> cache) {
                if (local) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
                }
                return (Map)cache.remove((Object)sessionId);
            }
        };
        this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)operation);
    }

    public void removeSessionLocal(String sessionId, String dataOwner) {
        DistributedCacheManager.trace("removeSessionLocal(%s, dataOwner)", sessionId, dataOwner);
        if (dataOwner == null) {
            this.removeSession(sessionId, true);
        }
    }

    public void evictSession(final String sessionId) {
        DistributedCacheManager.trace("evictSession(%s)", sessionId);
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, Map<Object, Object>> cache) {
                cache.evict((Object)sessionId);
                return null;
            }
        };
        this.invoker.invoke(this.sessionCache, (CacheInvoker.Operation)operation);
    }

    public void evictSession(String sessionId, String dataOwner) {
        DistributedCacheManager.trace("evictSession(%s, %s)", sessionId, dataOwner);
        if (dataOwner == null) {
            this.evictSession(sessionId);
        }
    }

    public Map<String, String> getSessionIds() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.sessionCache.keySet()) {
            result.put(key, null);
        }
        return result;
    }

    public boolean isPassivationEnabled() {
        return this.passivationEnabled;
    }

    public void setForceSynchronous(boolean forceSynchronous) {
        this.invoker.setForceSynchronous(forceSynchronous);
    }

    public SessionOwnershipSupport getSessionOwnershipSupport() {
        return this.lockManager != null ? this : null;
    }

    public SessionOwnershipSupport.LockResult acquireSessionOwnership(String sessionId, boolean newLock) throws TimeoutException, InterruptedException {
        DistributedCacheManager.trace("acquireSessionOwnership(%s, %s)", sessionId, newLock);
        EmbeddedCacheManager container = (EmbeddedCacheManager)this.sessionCache.getCacheManager();
        SessionOwnershipSupport.LockResult result = lockResultMap.get(this.lockManager.lock(this.getSessionLockKey(sessionId), container.getGlobalConfiguration().getDistributedSyncTimeout(), newLock));
        DistributedCacheManager.trace("acquireSessionOwnership(%s, %s) = %s", sessionId, newLock, result);
        return result != null ? result : SessionOwnershipSupport.LockResult.UNSUPPORTED;
    }

    public void relinquishSessionOwnership(String sessionId, boolean remove) {
        DistributedCacheManager.trace("relinquishSessionOwnership(%s, %s)", sessionId, remove);
        this.lockManager.unlock(this.getSessionLockKey(sessionId), remove);
    }

    private Serializable getSessionLockKey(String sessionId) {
        return this.sessionCache.getName() + "/" + sessionId;
    }

    public boolean isLocal(String sessionId) {
        DistributionManager manager = this.sessionCache.getAdvancedCache().getDistributionManager();
        return manager != null ? manager.isLocal((Object)sessionId) : true;
    }

    public String locate(String sessionId) {
        EmbeddedCacheManager container;
        List addresses;
        AdvancedCache cache;
        DistributionManager manager;
        if (this.jvmRouteHandler != null && (manager = (cache = this.sessionCache.getAdvancedCache()).getDistributionManager()) != null && !manager.isRehashInProgress() && !(addresses = manager.locate((Object)sessionId)).contains((container = (EmbeddedCacheManager)this.sessionCache.getCacheManager()).getAddress())) {
            Address address = (Address)addresses.get(random.nextInt(addresses.size()));
            String jvmRoute = (String)this.jvmRouteHandler.getCache().get((Object)address);
            if (jvmRoute != null) {
                DistributedCacheManager.trace("%s hashes to %s - next request will route to %s (%s)", sessionId, addresses, address, jvmRoute);
                cache.withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
                return jvmRoute;
            }
        }
        return this.manager.getJvmRoute();
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<String, Map<Object, Object>> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        this.manager.notifyRemoteInvalidation((String)event.getKey());
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<String, Map<Object, Object>> event) {
        boolean updated;
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        Map map = (Map)event.getValue();
        if (map.isEmpty()) {
            return;
        }
        String sessionId = (String)event.getKey();
        Integer version = (Integer)SessionMapEntry.VERSION.get(map);
        Long timestamp = (Long)SessionMapEntry.TIMESTAMP.get(map);
        DistributableSessionMetadata metadata = (DistributableSessionMetadata)SessionMapEntry.METADATA.get(map);
        if (version != null && timestamp != null && metadata != null && !(updated = this.manager.sessionChangedInDistributedCache(sessionId, null, version.intValue(), timestamp.longValue(), metadata))) {
            log.warn((Object)String.format("Possible concurrency problem: Replicated version id %d is less than or equal to in-memory version for session %s", version, DistributedCacheManager.mask(sessionId)));
        }
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<String, Map<Object, Object>> event) {
        if (event.isPre()) {
            return;
        }
        this.manager.sessionActivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R batch(Operation<R> operation) {
        boolean started = this.sessionCache.startBatch();
        boolean success = false;
        try {
            Object result = this.invoker.invoke(this.sessionCache, operation);
            success = true;
            Object object = result;
            return (R)object;
        }
        finally {
            if (started) {
                this.sessionCache.endBatch(success);
            }
        }
    }

    private static void trace(String message, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format(message, args));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Operation<R>
    extends CacheInvoker.Operation<String, Map<Object, Object>, R> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Listener(sync=false)
    public static class JvmRouteHandler {
        private final LocalDistributableSessionManager manager;
        private final CacheSource source;

        JvmRouteHandler(CacheSource source, LocalDistributableSessionManager manager) {
            this.source = source;
            this.manager = manager;
        }

        Cache<Address, String> getCache() {
            return this.source.getCache(this.manager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <R> R batch(Operation<R> operation) {
            Cache<Address, String> cache = this.getCache();
            boolean started = cache.startBatch();
            boolean success = false;
            try {
                Object result = operation.invoke(cache);
                success = true;
                Object object = result;
                return (R)object;
            }
            finally {
                if (started) {
                    cache.endBatch(success);
                }
            }
        }

        @ViewChanged
        public void viewChanged(final ViewChangedEvent event) {
            final List oldMembers = event.getOldMembers();
            final List newMembers = event.getNewMembers();
            final String jvmRoute = this.manager.getJvmRoute();
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<Address, String> cache) {
                    Address localAddress;
                    for (Address member : oldMembers) {
                        if (newMembers.contains(member) || cache.remove((Object)member) == null) continue;
                        log.info((Object)("Removed stale jvm route entry from web session cache on behalf of member " + member));
                    }
                    if (jvmRoute != null && !oldMembers.contains(localAddress = event.getLocalAddress()) && newMembers.contains(localAddress)) {
                        String oldJvmRoute = (String)cache.put((Object)localAddress, (Object)jvmRoute);
                        if (oldJvmRoute == null) {
                            log.info((Object)"Adding missing jvm route entry to web session cache");
                        } else if (!oldJvmRoute.equals(jvmRoute)) {
                            log.info((Object)("Updating jvm route entry in web session cache.  old = " + oldJvmRoute + ", new = " + jvmRoute));
                        }
                    }
                    return null;
                }
            };
            this.batch(operation);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static interface Operation<R>
        extends CacheInvoker.Operation<Address, String, R> {
        }
    }
}

