/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.ejbref.resolver.ejb31.impl;

import java.util.Collection;
import org.jboss.ejb3.ejbref.resolver.ejb30.impl.EJB30MetaDataBasedEjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReference;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedSessionBean31JNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;

public class EJB31MetaDataBasedEjbReferenceResolver
extends EJB30MetaDataBasedEjbReferenceResolver {
    private static Logger logger = Logger.getLogger(EJB31MetaDataBasedEjbReferenceResolver.class);
    protected DefaultJndiBindingPolicy jndiBindingPolicy;

    protected boolean isMatch(EjbReference reference, JBossSessionBeanMetaData md, ClassLoader cl) {
        if (this.hasNoInterfaceView(md) && md.getEjbClass().equals(reference.getBeanInterface())) {
            String requestedEJBName = reference.getBeanName();
            if (requestedEJBName != null && requestedEJBName.trim().length() > 0) {
                return requestedEJBName.equals(md.getEjbName());
            }
            return true;
        }
        return super.isMatch(reference, md, cl);
    }

    protected String getJNDIName(EjbReference reference, JBossSessionBeanMetaData smd, ClassLoader cl) {
        String mappedName = reference.getMappedName();
        if (mappedName != null && mappedName.trim().length() > 0) {
            logger.debug((Object)("Bypassing resolution, using mappedName of " + reference));
            return mappedName;
        }
        String interfaceName = reference.getBeanInterface();
        Collection eligibleInterfaces = this.getEligibleBeanInterfaces(smd);
        if (!eligibleInterfaces.contains(interfaceName)) {
            logger.debug((Object)("Found specified beanInterface that is not a direct beanInterface of EJB " + smd.getEjbName() + ": " + interfaceName));
            for (String eligibleInterface : eligibleInterfaces) {
                Collection parents = this.getAllParentInterfaces(eligibleInterface, cl);
                if (!parents.contains(interfaceName)) continue;
                logger.debug((Object)("Resolved specified beanInterface " + interfaceName + " to " + eligibleInterface + " for EJB " + smd.getEjbName()));
                interfaceName = eligibleInterface;
                break;
            }
        }
        JNDIPolicyBasedSessionBean31JNDINameResolver jndiNameResolver = this.getJNDINameResolver();
        String resolvedJndiName = jndiNameResolver.resolveJNDIName(smd, interfaceName);
        logger.debug((Object)("Resolved JNDI Name for " + reference + " of EJB " + smd.getEjbName() + ": " + resolvedJndiName));
        return resolvedJndiName;
    }

    public void setJNDIBindingPolicy(DefaultJndiBindingPolicy jndiBindingPolicy) {
        this.jndiBindingPolicy = jndiBindingPolicy;
    }

    protected boolean hasNoInterfaceView(JBossSessionBeanMetaData smd) {
        if (!this.isEJB31(smd)) {
            return false;
        }
        if (!(smd instanceof JBossSessionBean31MetaData)) {
            return false;
        }
        JBossSessionBean31MetaData sessionBean31 = (JBossSessionBean31MetaData)smd;
        return sessionBean31.isNoInterfaceBean();
    }

    protected boolean isEJB31(JBossSessionBeanMetaData smd) {
        JBossMetaData jbossMetaData = smd.getJBossMetaData();
        return jbossMetaData.isEJB31();
    }

    private JNDIPolicyBasedSessionBean31JNDINameResolver getJNDINameResolver() {
        if (this.jndiBindingPolicy == null) {
            return new JNDIPolicyBasedSessionBean31JNDINameResolver();
        }
        return new JNDIPolicyBasedSessionBean31JNDINameResolver(this.jndiBindingPolicy);
    }
}

