/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.impl.PagedMessageImpl;
import org.hornetq.core.persistence.StorageManager;

public class PageImpl
implements Page {
    private static final Logger log = Logger.getLogger(PageImpl.class);
    public static final int SIZE_RECORD = 6;
    private static final byte START_BYTE = 123;
    private static final byte END_BYTE = 125;
    private final int pageId;
    private boolean suspiciousRecords = false;
    private final AtomicInteger numberOfMessages = new AtomicInteger(0);
    private final SequentialFile file;
    private final SequentialFileFactory fileFactory;
    private final AtomicInteger size = new AtomicInteger(0);
    private final StorageManager storageManager;
    private final SimpleString storeName;

    public PageImpl(SimpleString storeName, StorageManager storageManager, SequentialFileFactory factory, SequentialFile file, int pageId) throws Exception {
        this.pageId = pageId;
        this.file = file;
        this.fileFactory = factory;
        this.storageManager = storageManager;
        this.storeName = storeName;
    }

    @Override
    public int getPageId() {
        return this.pageId;
    }

    @Override
    public List<PagedMessage> read() throws Exception {
        ArrayList<PagedMessage> messages = new ArrayList<PagedMessage>();
        ByteBuffer buffer2 = ByteBuffer.allocateDirect((int)this.file.size());
        this.file.position(0L);
        this.file.read(buffer2);
        buffer2.rewind();
        HornetQBuffer fileBuffer = HornetQBuffers.wrappedBuffer(buffer2);
        fileBuffer.writerIndex(fileBuffer.capacity());
        while (fileBuffer.readable()) {
            int position = fileBuffer.readerIndex();
            byte byteRead = fileBuffer.readByte();
            if (byteRead == 123) {
                if (fileBuffer.readerIndex() + 4 >= fileBuffer.capacity()) continue;
                int messageSize = fileBuffer.readInt();
                int oldPos = fileBuffer.readerIndex();
                if (fileBuffer.readerIndex() + messageSize < fileBuffer.capacity() && fileBuffer.getByte(oldPos + messageSize) == 125) {
                    PagedMessageImpl msg = new PagedMessageImpl();
                    msg.decode(fileBuffer);
                    byte b = fileBuffer.readByte();
                    if (b != 125) {
                        throw new IllegalStateException("Internal error, it wasn't possible to locate END_BYTE " + b);
                    }
                    messages.add(msg);
                    continue;
                }
                this.markFileAsSuspect(position, messages.size());
                break;
            }
            this.markFileAsSuspect(position, messages.size());
            break;
        }
        this.numberOfMessages.set(messages.size());
        return messages;
    }

    @Override
    public void write(PagedMessage message) throws Exception {
        ByteBuffer buffer = this.fileFactory.newBuffer(message.getEncodeSize() + 6);
        HornetQBuffer wrap = HornetQBuffers.wrappedBuffer(buffer);
        wrap.clear();
        wrap.writeByte((byte)123);
        wrap.writeInt(0);
        int startIndex = wrap.writerIndex();
        message.encode(wrap);
        int endIndex = wrap.writerIndex();
        wrap.setInt(1, endIndex - startIndex);
        wrap.writeByte((byte)125);
        buffer.rewind();
        this.file.writeDirect(buffer, false);
        this.numberOfMessages.incrementAndGet();
        this.size.addAndGet(buffer.limit());
        this.storageManager.pageWrite(message, this.pageId);
    }

    @Override
    public void sync() throws Exception {
        this.file.sync();
    }

    @Override
    public void open() throws Exception {
        this.file.open();
        this.size.set((int)this.file.size());
        this.file.position(0L);
    }

    @Override
    public void close() throws Exception {
        if (this.storageManager != null) {
            this.storageManager.pageClosed(this.storeName, this.pageId);
        }
        this.file.close();
    }

    @Override
    public boolean delete() throws Exception {
        if (this.storageManager != null) {
            this.storageManager.pageDeleted(this.storeName, this.pageId);
        }
        try {
            if (this.suspiciousRecords) {
                log.warn("File " + this.file.getFileName() + " being renamed to " + this.file.getFileName() + ".invalidPage as it was loaded partially. Please verify your data.");
                this.file.renameTo(this.file.getFileName() + ".invalidPage");
            } else {
                this.file.delete();
            }
            return true;
        }
        catch (Exception e) {
            log.warn("Error while deleting page file", e);
            return false;
        }
    }

    @Override
    public int getNumberOfMessages() {
        return this.numberOfMessages.intValue();
    }

    @Override
    public int getSize() {
        return this.size.intValue();
    }

    private void markFileAsSuspect(int position, int msgNumber) {
        log.warn("Page file had incomplete records at position " + position + " at record number " + msgNumber);
        this.suspiciousRecords = true;
    }
}

