/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.io.IOException;
import java.util.HashMap;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.stomp.StompException;
import org.hornetq.core.protocol.stomp.StompFrame;

class StompFrameDecoder {
    private static final Logger log = Logger.getLogger(StompFrameDecoder.class);
    private static final int MAX_COMMAND_LENGTH = 1024;
    private static final int MAX_HEADER_LENGTH = 10240;
    private static final int MAX_HEADERS = 1000;
    private static final int MAX_DATA_LENGTH = 0xA00000;

    StompFrameDecoder() {
    }

    public StompFrame decode(HornetQBuffer buffer) {
        try {
            String command = null;
            do {
                if ((command = StompFrameDecoder.readLine(buffer, 1024, "The maximum command length was exceeded")) != null) continue;
                return null;
            } while ((command = command.trim()).length() <= 0);
            HashMap<String, Object> headers = new HashMap<String, Object>(25);
            while (true) {
                String line;
                if ((line = StompFrameDecoder.readLine(buffer, 10240, "The maximum header length was exceeded")) == null) {
                    return null;
                }
                if (headers.size() > 1000) {
                    throw new StompException("The maximum number of headers was exceeded", true);
                }
                if (line.trim().length() == 0) break;
                try {
                    int seperator_index = line.indexOf(":");
                    if (seperator_index == -1) {
                        return null;
                    }
                    String name = line.substring(0, seperator_index).trim();
                    String value = line.substring(seperator_index + 1, line.length()).trim();
                    headers.put(name, value);
                }
                catch (Exception e) {
                    throw new StompException("Unable to parse header line [" + line + "]", true);
                }
            }
            byte[] data = StompFrame.NO_DATA;
            String contentLength = (String)headers.get("content-length");
            if (contentLength != null) {
                int length;
                try {
                    length = Integer.parseInt(contentLength.trim());
                }
                catch (NumberFormatException e) {
                    throw new StompException("Specified content-length is not a valid integer", true);
                }
                if (length > 0xA00000) {
                    throw new StompException("The maximum data length was exceeded", true);
                }
                if (buffer.readableBytes() < length) {
                    return null;
                }
                data = new byte[length];
                buffer.readBytes(data);
                if (!buffer.readable()) {
                    return null;
                }
                if (buffer.readByte() != 0) {
                    throw new StompException("content-length bytes were read and there was no trailing null byte", true);
                }
            } else {
                byte[] body = new byte[0xA00000];
                boolean bodyCorrectlyEnded = false;
                int count = 0;
                while (buffer.readable()) {
                    byte b = buffer.readByte();
                    if (b == 0) {
                        bodyCorrectlyEnded = true;
                        break;
                    }
                    body[count++] = b;
                }
                if (!bodyCorrectlyEnded) {
                    return null;
                }
                data = new byte[count];
                System.arraycopy(body, 0, data, 0, count);
            }
            return new StompFrame(command, headers, data);
        }
        catch (IOException e) {
            log.error("Unable to decode stomp frame", e);
            return null;
        }
    }

    private static String readLine(HornetQBuffer in, int maxLength, String errorMessage) throws IOException {
        char[] chars = new char[10240];
        if (!in.readable()) {
            return null;
        }
        boolean properString = false;
        int count = 0;
        while (in.readable()) {
            byte b = in.readByte();
            if (b == 10) {
                properString = true;
                break;
            }
            chars[count++] = (char)b;
        }
        if (properString) {
            return new String(chars, 0, count);
        }
        return null;
    }
}

