/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.cluster.DiscoveryEntry;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.cluster.DiscoveryListener;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.MessageFlowRecord;
import org.hornetq.core.server.cluster.RemoteQueueBinding;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.Response;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUID;

public class ClusterConnectionImpl
implements ClusterConnection,
DiscoveryListener {
    private static final Logger log = Logger.getLogger(ClusterConnectionImpl.class);
    private final ExecutorFactory executorFactory;
    private final HornetQServer server;
    private final PostOffice postOffice;
    private final ManagementService managementService;
    private final SimpleString name;
    private final SimpleString address;
    private final long retryInterval;
    private final boolean useDuplicateDetection;
    private final int confirmationWindowSize;
    private final boolean routeWhenNoConsumers;
    private final Map<String, MessageFlowRecord> records = new HashMap<String, MessageFlowRecord>();
    private final DiscoveryGroup discoveryGroup;
    private final ScheduledExecutorService scheduledExecutor;
    private final int maxHops;
    private final UUID nodeUUID;
    private final List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors;
    private boolean backup;
    private volatile boolean started;
    private final String clusterUser;
    private final String clusterPassword;

    public ClusterConnectionImpl(SimpleString name, SimpleString address, long retryInterval, boolean useDuplicateDetection, boolean routeWhenNoConsumers, int confirmationWindowSize, ExecutorFactory executorFactory, HornetQServer server, PostOffice postOffice, ManagementService managementService, ScheduledExecutorService scheduledExecutor, List<Pair<TransportConfiguration, TransportConfiguration>> connectors, int maxHops, UUID nodeUUID, boolean backup, String clusterUser, String clusterPassword) throws Exception {
        this.name = name;
        this.address = address;
        this.retryInterval = retryInterval;
        this.useDuplicateDetection = useDuplicateDetection;
        this.routeWhenNoConsumers = routeWhenNoConsumers;
        this.confirmationWindowSize = confirmationWindowSize;
        this.executorFactory = executorFactory;
        this.server = server;
        this.postOffice = postOffice;
        this.managementService = managementService;
        this.discoveryGroup = null;
        this.scheduledExecutor = scheduledExecutor;
        this.maxHops = maxHops;
        if (nodeUUID == null) {
            throw new IllegalArgumentException("node id is null");
        }
        this.nodeUUID = nodeUUID;
        this.backup = backup;
        this.staticConnectors = connectors;
        this.clusterUser = clusterUser;
        this.clusterPassword = clusterPassword;
        if (!backup) {
            this.updateFromStaticConnectors(connectors);
        }
    }

    public ClusterConnectionImpl(SimpleString name, SimpleString address, long retryInterval, boolean useDuplicateDetection, boolean routeWhenNoConsumers, int confirmationWindowSize, ExecutorFactory executorFactory, HornetQServer server, PostOffice postOffice, ManagementService managementService, ScheduledExecutorService scheduledExecutor, DiscoveryGroup discoveryGroup, int maxHops, UUID nodeUUID, boolean backup, String clusterUser, String clusterPassword) throws Exception {
        this.name = name;
        this.address = address;
        this.retryInterval = retryInterval;
        this.executorFactory = executorFactory;
        this.server = server;
        this.postOffice = postOffice;
        this.managementService = managementService;
        this.scheduledExecutor = scheduledExecutor;
        this.discoveryGroup = discoveryGroup;
        this.useDuplicateDetection = useDuplicateDetection;
        this.routeWhenNoConsumers = routeWhenNoConsumers;
        this.confirmationWindowSize = confirmationWindowSize;
        this.maxHops = maxHops;
        this.nodeUUID = nodeUUID;
        this.backup = backup;
        this.clusterUser = clusterUser;
        this.clusterPassword = clusterPassword;
        this.staticConnectors = null;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.discoveryGroup != null) {
            this.discoveryGroup.registerListener(this);
        }
        this.started = true;
        if (this.managementService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.CLUSTER_CONNECTION_STARTED, props);
            this.managementService.sendNotification(notification);
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.discoveryGroup != null) {
            this.discoveryGroup.unregisterListener(this);
        }
        for (MessageFlowRecord record : this.records.values()) {
            try {
                record.close();
            }
            catch (Exception exception) {}
        }
        if (this.managementService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.CLUSTER_CONNECTION_STOPPED, props);
            this.managementService.sendNotification(notification);
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public String getNodeID() {
        return this.nodeUUID.toString();
    }

    @Override
    public synchronized Map<String, String> getNodes() {
        HashMap<String, String> nodes = new HashMap<String, String>();
        for (Map.Entry<String, MessageFlowRecord> record : this.records.entrySet()) {
            if (record.getValue().getBridge().getForwardingConnection() == null) continue;
            nodes.put(record.getKey(), record.getValue().getBridge().getForwardingConnection().getRemoteAddress());
        }
        return nodes;
    }

    @Override
    public synchronized void activate() {
        if (!this.started) {
            return;
        }
        this.backup = false;
        if (this.discoveryGroup != null) {
            this.connectorsChanged();
        } else {
            try {
                this.updateFromStaticConnectors(this.staticConnectors);
            }
            catch (Exception e) {
                log.error("Failed to update connectors", e);
            }
        }
    }

    @Override
    public synchronized void connectorsChanged() {
        if (this.backup) {
            return;
        }
        try {
            Map<String, DiscoveryEntry> connectors = this.discoveryGroup.getDiscoveryEntryMap();
            this.updateConnectors(connectors);
        }
        catch (Exception e) {
            log.error("Failed to update connectors", e);
        }
    }

    private void updateFromStaticConnectors(List<Pair<TransportConfiguration, TransportConfiguration>> connectors) throws Exception {
        HashMap<String, DiscoveryEntry> map = new HashMap<String, DiscoveryEntry>();
        int i = 0;
        for (Pair<TransportConfiguration, TransportConfiguration> connectorPair : connectors) {
            map.put(String.valueOf(i++), new DiscoveryEntry(connectorPair, 0L));
        }
        this.updateConnectors(map);
    }

    private void updateConnectors(Map<String, DiscoveryEntry> connectors) throws Exception {
        Iterator<Map.Entry<String, MessageFlowRecord>> iter = this.records.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, MessageFlowRecord> entry = iter.next();
            if (connectors.containsKey(entry.getKey())) continue;
            entry.getValue().close();
            iter.remove();
        }
        for (Map.Entry<String, DiscoveryEntry> entry : connectors.entrySet()) {
            Queue queue;
            if (this.records.containsKey(entry.getKey())) continue;
            Pair<TransportConfiguration, TransportConfiguration> connectorPair = entry.getValue().getConnectorPair();
            SimpleString queueName = new SimpleString("sf." + this.name + "." + entry.getKey());
            Binding queueBinding = this.postOffice.getBinding(queueName);
            if (queueBinding != null) {
                queue = (Queue)queueBinding.getBindable();
                this.createNewRecord(entry.getKey(), connectorPair, queueName, queue, true);
                continue;
            }
            queue = this.server.createQueue(queueName, queueName, null, true, false);
            this.createNewRecord(entry.getKey(), connectorPair, queueName, queue, true);
        }
    }

    private void createNewRecord(String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, SimpleString queueName, Queue queue, boolean start) throws Exception {
        MessageFlowRecordImpl record = new MessageFlowRecordImpl(queue);
        BridgeImpl bridge = new BridgeImpl(this.nodeUUID, queueName, queue, null, -1, connectorPair, this.executorFactory.getExecutor(), null, null, this.scheduledExecutor, null, this.retryInterval, 1.0, -1, false, this.useDuplicateDetection, this.confirmationWindowSize, this.managementService.getManagementAddress(), this.managementService.getManagementNotificationAddress(), this.clusterUser, this.clusterPassword, record, !this.backup, this.server.getStorageManager());
        record.setBridge(bridge);
        this.records.put(nodeID, record);
        if (start) {
            bridge.start();
        }
    }

    @Override
    public void handleReplicatedAddBinding(SimpleString address, SimpleString uniqueName, SimpleString routingName, long queueID, SimpleString filterString, SimpleString queueName, int distance) throws Exception {
        Binding queueBinding = this.postOffice.getBinding(queueName);
        if (queueBinding == null) {
            throw new IllegalStateException("Cannot find s & f queue " + queueName);
        }
        Queue queue = (Queue)queueBinding.getBindable();
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(this.server.getStorageManager().generateUniqueID(), address, uniqueName, routingName, queueID, filterString, queue, queueName, distance);
        if (this.postOffice.getBinding(uniqueName) != null) {
            log.warn("Remoting queue binding " + uniqueName + " has already been bound in the post office. Most likely cause for this is you have a loop " + "in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses");
            return;
        }
        this.postOffice.addBinding(binding);
        Bindings theBindings = this.postOffice.getBindingsForAddress(address);
        theBindings.setRouteWhenNoConsumers(this.routeWhenNoConsumers);
    }

    public Map<String, MessageFlowRecord> getRecords() {
        return this.records;
    }

    private class MessageFlowRecordImpl
    implements MessageFlowRecord {
        private Bridge bridge;
        private final Queue queue;
        private final Map<SimpleString, RemoteQueueBinding> bindings = new HashMap<SimpleString, RemoteQueueBinding>();
        private volatile boolean firstReset = false;

        public MessageFlowRecordImpl(Queue queue) {
            this.queue = queue;
        }

        @Override
        public String getAddress() {
            return ClusterConnectionImpl.this.address.toString();
        }

        @Override
        public int getMaxHops() {
            return ClusterConnectionImpl.this.maxHops;
        }

        @Override
        public void close() throws Exception {
            this.bridge.stop();
            this.clearBindings();
        }

        @Override
        public void reset() throws Exception {
            this.clearBindings();
        }

        public void setBridge(Bridge bridge) {
            this.bridge = bridge;
        }

        @Override
        public Bridge getBridge() {
            return this.bridge;
        }

        @Override
        public synchronized void onMessage(ClientMessage message) {
            try {
                if (message.containsProperty(PostOfficeImpl.HDR_RESET_QUEUE_DATA)) {
                    this.clearBindings();
                    this.firstReset = true;
                    return;
                }
                if (!this.firstReset) {
                    return;
                }
                SimpleString type = message.getSimpleStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE);
                NotificationType ntype = NotificationType.valueOf(type.toString());
                switch (ntype) {
                    case BINDING_ADDED: {
                        this.doBindingAdded(message);
                        break;
                    }
                    case BINDING_REMOVED: {
                        this.doBindingRemoved(message);
                        break;
                    }
                    case CONSUMER_CREATED: {
                        this.doConsumerCreated(message);
                        break;
                    }
                    case CONSUMER_CLOSED: {
                        this.doConsumerClosed(message);
                        break;
                    }
                    case PROPOSAL: {
                        this.doProposalReceived(message);
                        break;
                    }
                    case PROPOSAL_RESPONSE: {
                        this.doProposalResponseReceived(message);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type " + (Object)((Object)ntype));
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to handle message", e);
            }
        }

        private synchronized void doProposalReceived(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID)) {
                throw new IllegalStateException("proposal type is null");
            }
            SimpleString type = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID);
            SimpleString val = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE);
            Integer hops = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            Response response = ClusterConnectionImpl.this.server.getGroupingHandler().receive(new Proposal(type, val), hops + 1);
            if (response != null) {
                ClusterConnectionImpl.this.server.getGroupingHandler().send(response, 0);
            }
        }

        private synchronized void doProposalResponseReceived(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID)) {
                throw new IllegalStateException("proposal type is null");
            }
            SimpleString type = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID);
            SimpleString val = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE);
            SimpleString alt = message.getSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_ALT_VALUE);
            Integer hops = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            Response response = new Response(type, val, alt);
            ClusterConnectionImpl.this.server.getGroupingHandler().proposed(response);
            ClusterConnectionImpl.this.server.getGroupingHandler().send(response, hops + 1);
        }

        private synchronized void clearBindings() throws Exception {
            for (RemoteQueueBinding binding : new HashSet<RemoteQueueBinding>(this.bindings.values())) {
                this.removeBinding(binding.getClusterName());
            }
        }

        private synchronized void doBindingAdded(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                throw new IllegalStateException("distance is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_ADDRESS)) {
                throw new IllegalStateException("queueAddress is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_ROUTING_NAME)) {
                throw new IllegalStateException("routingName is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_BINDING_ID)) {
                throw new IllegalStateException("queueID is null");
            }
            Integer distance = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            SimpleString queueAddress = message.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            SimpleString routingName = message.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
            SimpleString filterString = message.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
            Long queueID = message.getLongProperty(ManagementHelper.HDR_BINDING_ID);
            RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(ClusterConnectionImpl.this.server.getStorageManager().generateUniqueID(), queueAddress, clusterName, routingName, queueID, filterString, this.queue, this.bridge.getName(), distance + 1);
            if (ClusterConnectionImpl.this.postOffice.getBinding(clusterName) != null) {
                log.warn("Remote queue binding " + clusterName + " has already been bound in the post office. Most likely cause for this is you have a loop " + "in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses");
                return;
            }
            this.bindings.put(clusterName, binding);
            try {
                ClusterConnectionImpl.this.postOffice.addBinding(binding);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            Bindings theBindings = ClusterConnectionImpl.this.postOffice.getBindingsForAddress(queueAddress);
            theBindings.setRouteWhenNoConsumers(ClusterConnectionImpl.this.routeWhenNoConsumers);
        }

        private void doBindingRemoved(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            this.removeBinding(clusterName);
        }

        private synchronized void removeBinding(SimpleString clusterName) throws Exception {
            RemoteQueueBinding binding = this.bindings.remove(clusterName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for queue " + clusterName);
            }
            ClusterConnectionImpl.this.postOffice.removeBinding(binding.getUniqueName());
        }

        private synchronized void doConsumerCreated(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                throw new IllegalStateException("distance is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            Integer distance = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            message.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            SimpleString filterString = message.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
            RemoteQueueBinding binding = this.bindings.get(clusterName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for " + clusterName);
            }
            binding.addConsumer(filterString);
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, clusterName);
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            Queue theQueue = (Queue)binding.getBindable();
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
            if (filterString != null) {
                props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
            }
            Notification notification = new Notification(null, NotificationType.CONSUMER_CREATED, props);
            ClusterConnectionImpl.this.managementService.sendNotification(notification);
        }

        private synchronized void doConsumerClosed(ClientMessage message) throws Exception {
            if (!message.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                throw new IllegalStateException("distance is null");
            }
            if (!message.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                throw new IllegalStateException("clusterName is null");
            }
            Integer distance = message.getIntProperty(ManagementHelper.HDR_DISTANCE);
            SimpleString clusterName = message.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            message.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            SimpleString filterString = message.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
            RemoteQueueBinding binding = this.bindings.get(clusterName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding for " + clusterName);
            }
            binding.removeConsumer(filterString);
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, clusterName);
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance + 1);
            Queue theQueue = (Queue)binding.getBindable();
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
            if (filterString != null) {
                props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
            }
            Notification notification = new Notification(null, NotificationType.CONSUMER_CLOSED, props);
            ClusterConnectionImpl.this.managementService.sendNotification(notification);
        }
    }
}

