/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.remoting3.ClientContext;
import org.jboss.remoting3.ClientContextImpl;
import org.jboss.remoting3.IndeterminateOutcomeException;
import org.jboss.remoting3.RemoteExecutionException;
import org.jboss.remoting3.RemoteReplyException;
import org.jboss.remoting3.RequestCancelHandler;
import org.jboss.remoting3.RequestContext;
import org.jboss.remoting3.RequestListenerExecutor;
import org.jboss.remoting3.spi.RemoteReplyHandler;
import org.jboss.remoting3.spi.SpiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequestContextImpl<O>
implements RequestContext<O> {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Object cancelLock = new Object();
    private final RemoteReplyHandler replyHandler;
    private final ClientContextImpl clientContext;
    private boolean cancelled;
    private Set<RequestCancelHandler<O>> cancelHandlers;
    private final RequestListenerExecutor interruptingExecutor;
    private final Class<O> replyClass;
    private final ClassLoader serviceClassLoader;

    RequestContextImpl(RemoteReplyHandler replyHandler, ClientContextImpl clientContext, Class<O> replyClass, ClassLoader serviceClassLoader) {
        this.replyHandler = replyHandler;
        this.clientContext = clientContext;
        this.replyClass = replyClass;
        this.serviceClassLoader = serviceClassLoader;
        Executor executor = clientContext.getExecutor();
        this.interruptingExecutor = new RequestListenerExecutor(executor);
    }

    @Override
    public ClientContext getContext() {
        return this.clientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.cancelLock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    @Override
    public void sendReply(O reply) throws IOException, IllegalStateException {
        if (!this.closed.getAndSet(true)) {
            O actualReply;
            try {
                actualReply = this.replyClass.cast(reply);
            }
            catch (ClassCastException e) {
                SpiUtils.safeHandleException(this.replyHandler, (IOException)new RemoteReplyException("Remote reply was the wrong type", e));
                throw e;
            }
            try {
                this.replyHandler.handleReply(actualReply);
            }
            catch (IOException e) {
                SpiUtils.safeHandleException(this.replyHandler, (IOException)new RemoteReplyException("Remote reply failed", e));
                throw e;
            }
        }
        throw new IllegalStateException("Reply already sent");
    }

    @Override
    public void sendFailure(String msg, Throwable cause) throws IOException, IllegalStateException {
        if (this.closed.getAndSet(true)) {
            throw new IllegalStateException("Reply already sent");
        }
        this.replyHandler.handleException(new RemoteExecutionException(msg, cause));
    }

    @Override
    public void sendCancelled() throws IOException, IllegalStateException {
        if (!this.closed.getAndSet(true)) {
            try {
                this.replyHandler.handleCancellation();
            }
            catch (IOException e) {
                SpiUtils.safeHandleException(this.replyHandler, (IOException)new RemoteReplyException("Remote cancellation acknowledgement failed", e));
            }
        } else {
            throw new IllegalStateException("Reply already sent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCancelHandler(RequestCancelHandler<O> handler) {
        Object object = this.cancelLock;
        synchronized (object) {
            if (this.cancelled) {
                SpiUtils.safeNotifyCancellation(handler, this);
            } else {
                if (this.cancelHandlers == null) {
                    this.cancelHandlers = new HashSet<RequestCancelHandler<O>>();
                }
                this.cancelHandlers.add(handler);
            }
        }
    }

    @Override
    public void execute(final Runnable command) {
        this.interruptingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SecurityManager sm = System.getSecurityManager();
                ClassLoaderAction saveAction = new ClassLoaderAction(RequestContextImpl.this.serviceClassLoader);
                ClassLoader old = sm != null ? AccessController.doPrivileged(saveAction) : saveAction.run();
                ClassLoaderAction restoreAction = new ClassLoaderAction(old);
                try {
                    command.run();
                }
                finally {
                    if (sm != null) {
                        AccessController.doPrivileged(restoreAction);
                    } else {
                        restoreAction.run();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.cancelHandlers != null) {
                    for (final RequestCancelHandler<O> handler : this.cancelHandlers) {
                        this.interruptingExecutor.execute(new Runnable(){

                            public void run() {
                                SpiUtils.safeNotifyCancellation(handler, RequestContextImpl.this);
                            }
                        });
                    }
                    this.cancelHandlers = null;
                }
                this.interruptingExecutor.interruptAll();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed.getAndSet(true)) {
            SpiUtils.safeHandleException(this.replyHandler, (IOException)new IndeterminateOutcomeException("No reply was sent by the request listener"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private final ClassLoader classLoader;

        public ClassLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassLoader run() {
            Thread thread = Thread.currentThread();
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                return classLoader;
            }
            finally {
                thread.setContextClassLoader(this.classLoader);
            }
        }
    }
}

