/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.remote.SaslContext;
import org.jboss.xnio.channels.MessageHandler;

final class SaslUnwrappingMessageHandler
implements MessageHandler,
MessageHandler.Setter {
    private final SaslContext saslContext;
    private volatile MessageHandler delegate;

    SaslUnwrappingMessageHandler(SaslContext saslContext, MessageHandler delegate) {
        this.saslContext = saslContext;
        this.delegate = delegate;
    }

    public void handleMessage(ByteBuffer buffer) {
        try {
            this.delegate.handleMessage(this.saslContext.unwrap(buffer));
        }
        catch (SaslException e) {
            this.delegate.handleException((IOException)e);
        }
    }

    public void handleEof() {
        this.delegate.handleEof();
    }

    public void handleException(IOException e) {
        this.delegate.handleException(e);
    }

    public void set(MessageHandler messageHandler) {
        this.delegate = messageHandler;
    }
}

