/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.stream;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jboss.marshalling.ByteOutput;
import org.jboss.remoting3.stream.Streams;

public final class WriterOutputStream
extends OutputStream
implements ByteOutput {
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final ByteBuffer byteBuffer;
    private final char[] chars;
    private volatile boolean closed;

    public WriterOutputStream(Writer writer) {
        this(writer, Charset.defaultCharset());
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder) {
        this(writer, decoder, 1024);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder, int bufferSize) {
        this.writer = writer;
        this.decoder = decoder;
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        this.chars = new char[(int)((float)bufferSize * decoder.maxCharsPerByte() + 0.5f)];
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, WriterOutputStream.getDecoder(charset));
    }

    public WriterOutputStream(Writer writer, String charsetName) throws UnsupportedEncodingException {
        this(writer, Streams.getCharset(charsetName));
    }

    private static CharsetDecoder getDecoder(Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder.replaceWith("?");
        return decoder;
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        ByteBuffer byteBuffer = this.byteBuffer;
        if (!byteBuffer.hasRemaining()) {
            this.doFlush(false);
        }
        byteBuffer.put((byte)b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        ByteBuffer byteBuffer = this.byteBuffer;
        while (len > 0) {
            int r = byteBuffer.remaining();
            if (r == 0) {
                this.doFlush(false);
                continue;
            }
            int c = Math.min(len, r);
            byteBuffer.put(b, off, c);
            len -= c;
            off += c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(boolean eof) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(this.chars);
        ByteBuffer byteBuffer = this.byteBuffer;
        CharsetDecoder decoder = this.decoder;
        byteBuffer.flip();
        try {
            while (byteBuffer.hasRemaining()) {
                CoderResult result = decoder.decode(byteBuffer, charBuffer, eof);
                if (result.isOverflow()) {
                    this.writer.write(this.chars, 0, charBuffer.position());
                    charBuffer.clear();
                    continue;
                }
                if (result.isUnderflow()) {
                    int p = charBuffer.position();
                    if (p > 0) {
                        this.writer.write(this.chars, 0, p);
                    }
                    return;
                }
                if (!result.isError()) continue;
                if (result.isMalformed()) {
                    throw new CharConversionException("Malformed input");
                }
                if (result.isUnmappable()) {
                    throw new CharConversionException("Unmappable character");
                }
                throw new CharConversionException("Character decoding problem");
            }
        }
        finally {
            byteBuffer.compact();
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.writer.flush();
    }

    public void close() throws IOException {
        this.closed = true;
        this.doFlush(true);
        this.byteBuffer.clear();
        this.writer.close();
    }

    public String toString() {
        return "Output stream writing to " + this.writer;
    }
}

