/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SemaphoreValve
extends ValveBase
implements Lifecycle {
    private static final String info = "org.apache.catalina.valves.SemaphoreValve/1.0";
    private StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    protected Semaphore semaphore = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private boolean started = false;
    protected int concurrency = 10;
    protected boolean fairness = false;
    protected boolean block = true;
    protected boolean interruptible = false;

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public boolean getFairness() {
        return this.fairness;
    }

    public void setFairness(boolean fairness) {
        this.fairness = fairness;
    }

    public boolean getBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public boolean getInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("semaphoreValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.semaphore = new Semaphore(this.concurrency, this.fairness);
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("semaphoreValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.semaphore = null;
    }

    @Override
    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.controlConcurrency(request, response)) {
            boolean shouldRelease = true;
            try {
                if (this.block) {
                    if (this.interruptible) {
                        try {
                            this.semaphore.acquire();
                        }
                        catch (InterruptedException e) {
                            shouldRelease = false;
                            this.permitDenied(request, response);
                            if (shouldRelease) {
                                this.semaphore.release();
                            }
                            return;
                        }
                    } else {
                        this.semaphore.acquireUninterruptibly();
                    }
                } else if (!this.semaphore.tryAcquire()) {
                    shouldRelease = false;
                    this.permitDenied(request, response);
                    return;
                }
                this.getNext().invoke(request, response);
            }
            finally {
                if (shouldRelease) {
                    this.semaphore.release();
                }
            }
        } else {
            this.getNext().invoke(request, response);
        }
    }

    public boolean controlConcurrency(Request request, Response response) {
        return true;
    }

    public void permitDenied(Request request, Response response) throws IOException, ServletException {
    }
}

