/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.jopr;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.integration.hornetq.jopr.JMSConstants;
import org.jboss.as.integration.hornetq.jopr.JMSResourceComponent;
import org.jboss.as.integration.hornetq.jopr.util.ManagementSupport;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSQueueComponent
extends JMSResourceComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet,
ConfigurationFacet {
    @Override
    String getMeasurementsOperationName() {
        return "getQueueMeasurements";
    }

    @Override
    public AvailabilityType getAvailability() {
        try {
            ManagementView view = this.getProfileService();
            ManagedOperation operation = ManagementSupport.getOperation(view, this.getComponentName(), "isPaused", this.getComponentType());
            SimpleValueSupport val = (SimpleValueSupport)operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.resourceContext.getResourceKey()))});
            boolean paused = (Boolean)val.getValue();
            return paused ? AvailabilityType.DOWN : AvailabilityType.UP;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    @Override
    String getComponentName() {
        return "JMSQueueManageMO";
    }

    @Override
    ComponentType getComponentType() {
        return JMSConstants.Queue.COMPONENT_TYPE;
    }

    @Override
    String getConfigurationOperationName() {
        return "getQueueConfiguration";
    }

    @Override
    protected String getInvokeOperation() {
        return "invokeQueueOperation";
    }

    @Override
    protected String getInvokeOperationJMSMessage() {
        return "invokeQueueOperationMessageType";
    }

    @Override
    protected String getInvokeOperationSubscriptionMessage() {
        return null;
    }

    @Override
    String getDeleteOperationName() {
        return "deleteQueue";
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        configurationUpdateReport.setStatus(ConfigurationUpdateStatus.INPROGRESS);
        ManagementView view = null;
        try {
            view = this.getProfileService();
        }
        catch (Exception e) {
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage(e.getMessage());
            e.printStackTrace();
            return;
        }
        Map simpleProps = configurationUpdateReport.getConfiguration().getSimpleProperties();
        String name = ((PropertySimple)simpleProps.get("name")).getStringValue();
        String jndiName = ((PropertySimple)simpleProps.get("jndiBindings")).getStringValue();
        String DLA = ((PropertySimple)simpleProps.get("dla")).getStringValue();
        String expiryAddress = ((PropertySimple)simpleProps.get("expiryAddress")).getStringValue();
        int maxSize = ((PropertySimple)simpleProps.get("maxSize")).getIntegerValue();
        int pageSize = ((PropertySimple)simpleProps.get("pageSize")).getIntegerValue();
        int maxDeliveryAttempts = ((PropertySimple)simpleProps.get("maxDeliveryAttempts")).getIntegerValue();
        long redeliveryDelay = ((PropertySimple)simpleProps.get("redeliveryDelay")).getLongValue();
        boolean lastValueQueue = ((PropertySimple)simpleProps.get("lastValueQueue")).getBooleanValue();
        long redistributionDelay = ((PropertySimple)simpleProps.get("redistributionDelay")).getLongValue();
        boolean sendToDLAOnNoRoute = ((PropertySimple)simpleProps.get("sendToDLAOnNoRoute")).getBooleanValue();
        String addressFullMessagePolicy = ((PropertySimple)simpleProps.get("addressFullMessagePolicy")).getStringValue();
        StringBuffer sendRoles = new StringBuffer();
        StringBuffer consumeRoles = new StringBuffer();
        this.createRoles(configurationUpdateReport, name, sendRoles, consumeRoles);
        try {
            ManagedOperation operation = ManagementSupport.getOperation(view, "JMSQueueManageMO", "updateQueueConfiguration", JMSConstants.Queue.COMPONENT_TYPE);
            operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.resourceContext.getResourceKey())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)jndiName)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)DLA)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)expiryAddress)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(pageSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxDeliveryAttempts)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redeliveryDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(lastValueQueue)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redistributionDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(sendToDLAOnNoRoute)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)addressFullMessagePolicy)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)sendRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)consumeRoles.toString()))});
        }
        catch (Exception e) {
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage(e.getMessage());
            e.printStackTrace();
            return;
        }
        configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }

    private void createRoles(ConfigurationUpdateReport configurationUpdateReport, String name, StringBuffer sendRoles, StringBuffer consumeRoles) {
        PropertyList propertyList = (PropertyList)configurationUpdateReport.getConfiguration().get("roles");
        if (propertyList == null) {
            return;
        }
        List roles = propertyList.getList();
        for (Property role : roles) {
            PropertyMap actRole = (PropertyMap)role;
            PropertySimple simple = (PropertySimple)actRole.get("name");
            name = simple.getStringValue();
            simple = (PropertySimple)actRole.get("send");
            boolean send = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("consume");
            boolean consume = simple.getBooleanValue();
            if (send) {
                if (sendRoles.length() > 0) {
                    sendRoles.append(",");
                }
                sendRoles.append(name);
            }
            if (!consume) continue;
            if (consumeRoles.length() > 0) {
                consumeRoles.append(",");
            }
            consumeRoles.append(name);
        }
    }

    private void populateParams(Collection<PropertySimple> props, SimpleValueSupport[] params, SimpleValueSupport[] signature) {
        int pos = 0;
        for (PropertySimple prop : props) {
            String[] val = prop.getName().split(":");
            if (val.length == 1) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getStringValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.String"));
            } else if (val[0].equals("Boolean")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getBooleanValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Boolean"));
            } else if (val[0].equals("boolean")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getBooleanValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"boolean"));
            } else if (val[0].equals("String")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getStringValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.String"));
            } else if (val[0].equals("Long")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getLongValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Long"));
            } else if (val[0].equals("long")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getLongValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"long"));
            } else if (val[0].equals("Integer")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getIntegerValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Integer"));
            } else if (val[0].equals("int")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getIntegerValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"int"));
            } else if (val[0].equals("Double")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getDoubleValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"java.lang.Double"));
            } else if (val[0].equals("double")) {
                params[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getStringValue(prop.getDoubleValue())));
                signature[pos] = new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)"double"));
            }
            ++pos;
        }
    }

    private String getStringValue(Object o) {
        return o == null ? "null" : o.toString();
    }

    private OperationResult formatResults(Object val, String type) throws Exception {
        if (type == null) {
            SimpleValueSupport valueSupport = (SimpleValueSupport)val;
            return new OperationResult(valueSupport.getValue().toString());
        }
        if (type.equalsIgnoreCase("String")) {
            SimpleValueSupport valueSupport = (SimpleValueSupport)val;
            return new OperationResult(valueSupport.getValue().toString());
        }
        if (type.equalsIgnoreCase("JMSMessage")) {
            MetaValue[] msgs;
            OperationResult operationResult = new OperationResult();
            Configuration c = operationResult.getComplexResults();
            PropertyList property = new PropertyList("result");
            CollectionValueSupport valueSupport = (CollectionValueSupport)val;
            for (MetaValue mv : msgs = valueSupport.getElements()) {
                CompositeValueSupport msg = (CompositeValueSupport)mv;
                PropertyMap p1 = new PropertyMap("element");
                property.add((Property)p1);
                ImmutableCompositeMetaType metaType = (ImmutableCompositeMetaType)msg.getMetaType();
                Set keys = metaType.keySet();
                for (String key : keys) {
                    SimpleValueSupport sattr = (SimpleValueSupport)msg.get(key);
                    p1.put((Property)new PropertySimple(key, (Object)sattr.getValue()));
                }
            }
            c.put((Property)property);
            return operationResult;
        }
        if (val instanceof CompositeValueSupport) {
            CompositeValueSupport valueSupport = (CompositeValueSupport)val;
            if (valueSupport.containsKey("cause")) {
                CompositeValueSupport cause = (CompositeValueSupport)valueSupport.get("cause");
                SimpleValueSupport message = (SimpleValueSupport)cause.get("message");
                Exception exception = new Exception(message.toString());
                throw exception;
            }
            return new OperationResult("not yet");
        }
        return new OperationResult("not yet");
    }
}

