/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.kernel;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.kernel.LazyJNDIKernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.logging.Logger;

public class JNDIKernelRegistryPlugin
implements KernelRegistryPlugin {
    private static final Logger log = Logger.getLogger(JNDIKernelRegistryPlugin.class);
    public static final String JNDI_DEPENDENCY_PREFIX = "jndi:";
    private Context context;
    private Hashtable<?, ?> environment;

    public JNDIKernelRegistryPlugin() {
    }

    public JNDIKernelRegistryPlugin(Hashtable environment) {
        this.environment = environment;
    }

    public void create() throws NamingException {
        log.debug((Object)"Creating JNDIKernelRegistryPlugin");
        this.context = InitialContextFactory.getInitialContext(this.environment);
    }

    public void destroy() throws NamingException {
        log.debug((Object)"Destroying JNDIKernelRegistryPlugin");
        if (this.context != null) {
            this.context.close();
        }
        this.context = null;
    }

    public KernelRegistryEntry getEntry(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String s = String.valueOf(name);
        if (!s.startsWith(JNDI_DEPENDENCY_PREFIX)) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("get entry for " + name));
        }
        String jndiName = s.substring(JNDI_DEPENDENCY_PREFIX.length());
        try {
            if (this.isBoundInJNDI(jndiName)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found in jndi " + jndiName + "for MC name " + name));
                }
                return new LazyJNDIKernelRegistryEntry(this.context, jndiName);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Not available in jndi " + jndiName + " for MC name " + name));
            }
            return null;
        }
        catch (NamingException ne) {
            log.error((Object)("Can't resolve JNDI name " + jndiName + " for MC name " + name));
            throw new RuntimeException("Can't resolve JNDI name " + jndiName + " for MC name " + name, ne);
        }
    }

    public void setEnvironment(Hashtable<?, ?> env) {
        if (this.context != null) {
            throw new IllegalStateException("context already initialized");
        }
        this.environment = env;
    }

    private boolean isBoundInJNDI(String jndiName) throws NamingException {
        NameParser nameParser = this.context.getNameParser(jndiName);
        Name nameInJNDI = nameParser.parse(jndiName);
        if (nameInJNDI.isEmpty()) {
            return false;
        }
        int numberOfComponents = nameInJNDI.size();
        if (numberOfComponents == 1) {
            NamingEnumeration<Binding> bindings = this.context.listBindings("");
            while (bindings.hasMoreElements()) {
                Binding binding = (Binding)bindings.nextElement();
                if (!binding.getName().equals(nameInJNDI.get(0))) continue;
                return true;
            }
            return false;
        }
        if (numberOfComponents > 1) {
            Name parentCtx = nameInJNDI.getPrefix(numberOfComponents - 1);
            String atom = nameInJNDI.get(numberOfComponents - 1);
            try {
                NamingEnumeration<Binding> bindings = this.context.listBindings(parentCtx);
                while (bindings.hasMoreElements()) {
                    Binding binding = (Binding)bindings.nextElement();
                    if (!binding.getName().equals(atom)) continue;
                    return true;
                }
            }
            catch (NotContextException nce) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Not found in JNDI " + jndiName + " since " + parentCtx + " is not bound"));
                }
                return false;
            }
            catch (NameNotFoundException nnfe) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Not found in JNDI " + jndiName + " since sub-context(s) within parentCtx " + parentCtx + " is not bound"));
                }
                return false;
            }
        }
        return false;
    }
}

