/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.security.SecurityActions;
import org.jboss.ejb3.security.SecurityHelper;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;

public class RunAsSecurityInterceptorv2
implements Interceptor {
    private RunAsIdentity runAsIdentity;
    private EJBContainer container;

    public RunAsSecurityInterceptorv2(EJBContainer container, RunAsIdentity id) {
        this.runAsIdentity = id;
        this.container = container;
    }

    protected RunAsIdentity getRunAsIdentity(Invocation invocation) {
        return this.runAsIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        SecurityDomain domain;
        SecurityContext sc;
        SecurityContext cachedContext = null;
        SecurityHelper shelper = new SecurityHelper();
        if (shelper.isEJBTimeOutCallback(((MethodInvocation)invocation).getMethod())) {
            return invocation.invokeNext();
        }
        cachedContext = sc = SecurityActions.getSecurityContext();
        if (this.container instanceof MessagingContainer) {
            sc = null;
        }
        if (sc == null && (domain = this.container.getAnnotation(SecurityDomain.class)) != null) {
            sc = SecurityActions.createSecurityContext(domain.value());
            SecurityActions.setSecurityContext(sc);
        }
        if (sc != null) {
            sc.setOutgoingRunAs((RunAs)this.runAsIdentity);
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            if (sc != null) {
                SecurityActions.popRunAs();
            }
            SecurityActions.setSecurityContext(cachedContext);
        }
    }

    public String getName() {
        return this.getClass().getName();
    }
}

