/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.binding.http.interceptor.ContentTypeOutInterceptor;
import org.apache.cxf.binding.http.interceptor.DatabindingInSetupInterceptor;
import org.apache.cxf.binding.http.interceptor.DatabindingOutSetupInterceptor;
import org.apache.cxf.binding.http.strategy.ConventionStrategy;
import org.apache.cxf.binding.http.strategy.JRAStrategy;
import org.apache.cxf.binding.http.strategy.ResourceStrategy;
import org.apache.cxf.binding.xml.XMLBinding;
import org.apache.cxf.binding.xml.interceptor.XMLFaultInInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLFaultOutInterceptor;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class HttpBindingFactory
extends AbstractBindingFactory {
    public static final String HTTP_BINDING_ID = "http://apache.org/cxf/binding/http";
    private List<ResourceStrategy> strategies = new ArrayList<ResourceStrategy>();

    public HttpBindingFactory() {
        this.strategies.add(new JRAStrategy());
        this.strategies.add(new ConventionStrategy());
    }

    public Binding createBinding(BindingInfo bi) {
        XMLBinding binding = new XMLBinding(bi);
        binding.getInInterceptors().add(new AttachmentInInterceptor());
        binding.getInInterceptors().add(new DatabindingInSetupInterceptor());
        binding.getOutInterceptors().add(new AttachmentOutInterceptor());
        binding.getOutInterceptors().add(new ContentTypeOutInterceptor());
        binding.getOutInterceptors().add(new DatabindingOutSetupInterceptor());
        binding.getInFaultInterceptors().add(new XMLFaultInInterceptor());
        binding.getOutFaultInterceptors().add(new ContentTypeOutInterceptor());
        binding.getOutFaultInterceptors().add(new StaxOutInterceptor());
        binding.getOutFaultInterceptors().add(new XMLFaultOutInterceptor());
        return binding;
    }

    public BindingInfo createBindingInfo(Service service, String namespace, Object obj) {
        URIMapper mapper = new URIMapper();
        ServiceInfo si = (ServiceInfo)service.getServiceInfos().get(0);
        BindingInfo info = new BindingInfo(si, HTTP_BINDING_ID);
        info.setName(new QName(si.getName().getNamespaceURI(), si.getName().getLocalPart() + "HttpBinding"));
        service.put((Object)URIMapper.class.getName(), (Object)mapper);
        MethodDispatcher md = (MethodDispatcher)service.get((Object)MethodDispatcher.class.getName());
        for (OperationInfo o : si.getInterface().getOperations()) {
            BindingOperationInfo bop = info.buildOperation(o.getName(), o.getInputName(), o.getOutputName());
            info.addOperation(bop);
            Method m = md.getMethod(bop);
            try {
                Class c = (Class)service.get((Object)"endpoint.class");
                if (c != null) {
                    m = c.getMethod(m.getName(), m.getParameterTypes());
                }
            }
            catch (SecurityException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            for (ResourceStrategy s : this.strategies) {
                if (s.map(bop, m, mapper)) break;
            }
        }
        return info;
    }

    public List<ResourceStrategy> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(List<ResourceStrategy> strategies) {
        this.strategies = strategies;
    }
}

