/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.util.IntKeyMap;
import org.jboss.remoting3.IndeterminateOutcomeException;
import org.jboss.remoting3.ServiceOpenException;
import org.jboss.remoting3.remote.InboundClient;
import org.jboss.remoting3.remote.InboundRequest;
import org.jboss.remoting3.remote.InboundStream;
import org.jboss.remoting3.remote.OutboundClient;
import org.jboss.remoting3.remote.OutboundRequest;
import org.jboss.remoting3.remote.OutboundStream;
import org.jboss.remoting3.remote.PrimaryClassTable;
import org.jboss.remoting3.remote.PrimaryExternalizerFactory;
import org.jboss.remoting3.remote.PrimaryObjectTable;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.UnsentRequestHandlerConnector;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.RequestHandlerConnector;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Pool;
import org.jboss.xnio.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteConnectionHandler
extends AbstractHandleableCloseable<RemoteConnectionHandler>
implements ConnectionHandler {
    static final int LENGTH_PLACEHOLDER = 0;
    private final Pool<ByteBuffer> bufferPool = Buffers.createHeapByteBufferAllocator((int)4096);
    private final MarshallerFactory marshallerFactory;
    private final MarshallingConfiguration marshallingConfiguration;
    private final ConnectionHandlerContext connectionContext;
    private final RemoteConnection remoteConnection;
    private final Random random = new Random();
    private final IntKeyMap<OutboundClient> outboundClients = new IntKeyMap();
    private final IntKeyMap<InboundClient> inboundClients = new IntKeyMap();
    private final IntKeyMap<OutboundRequest> outboundRequests = new IntKeyMap();
    private final IntKeyMap<InboundRequest> inboundRequests = new IntKeyMap();
    private final IntKeyMap<OutboundStream> outboundStreams = new IntKeyMap();
    private final IntKeyMap<InboundStream> inboundStreams = new IntKeyMap();
    private static final ThreadLocal<RemoteConnectionHandler> current = new ThreadLocal();

    RemoteConnectionHandler(ConnectionHandlerContext connectionContext, RemoteConnection remoteConnection, MarshallerFactory marshallerFactory) {
        super(connectionContext.getConnectionProviderContext().getExecutor());
        this.connectionContext = connectionContext;
        this.remoteConnection = remoteConnection;
        this.marshallerFactory = marshallerFactory;
        MarshallingConfiguration config = new MarshallingConfiguration();
        PrimaryExternalizerFactory externalizerFactory = new PrimaryExternalizerFactory(this);
        PrimaryObjectTable objectTable = new PrimaryObjectTable(connectionContext.getConnectionProviderContext().getEndpoint(), externalizerFactory);
        config.setClassTable((ClassTable)PrimaryClassTable.INSTANCE);
        config.setClassExternalizerFactory((ClassExternalizerFactory)externalizerFactory);
        config.setObjectTable((ObjectTable)objectTable);
        config.setStreamHeader(Marshalling.nullStreamHeader());
        config.setVersion(2);
        this.marshallingConfiguration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable open(String serviceType, String groupName, Result<RemoteRequestHandler> result, ClassLoader classLoader, OptionMap optionMap) {
        OutboundClient outboundClient;
        int id;
        IntKeyMap<OutboundClient> intKeyMap = this.outboundClients;
        synchronized (intKeyMap) {
            while (this.outboundClients.containsKey(id = this.random.nextInt() | 1)) {
            }
            outboundClient = new OutboundClient(this, id, result, serviceType, groupName);
            this.outboundClients.put(id, (Object)outboundClient);
        }
        ByteBuffer buffer = (ByteBuffer)this.bufferPool.allocate();
        try {
            buffer.putInt(0);
            buffer.put((byte)16);
            buffer.putInt(id);
            Buffers.putModifiedUtf8((ByteBuffer)buffer, (String)serviceType);
            buffer.put((byte)0);
            Buffers.putModifiedUtf8((ByteBuffer)buffer, (String)groupName);
            buffer.put((byte)0);
            ByteOutput output = Marshalling.createByteOutput((ByteBuffer)buffer);
            Marshaller marshaller = this.marshallerFactory.createMarshaller(this.marshallingConfiguration);
            try {
                marshaller.start(output);
                marshaller.writeObject((Object)optionMap);
                marshaller.finish();
                buffer.flip();
                this.remoteConnection.sendBlocking(buffer, true);
            }
            finally {
                IoUtils.safeClose((Closeable)marshaller);
            }
        }
        catch (IOException e) {
            result.setException(e);
        }
        catch (Throwable e) {
            result.setException((IOException)new ServiceOpenException("Failed to open service", e));
        }
        finally {
            this.bufferPool.free((Object)buffer);
        }
        return outboundClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestHandlerConnector createConnector(LocalRequestHandler localHandler) {
        int id;
        IntKeyMap<InboundClient> intKeyMap = this.inboundClients;
        synchronized (intKeyMap) {
            while (this.inboundClients.containsKey(id = this.random.nextInt() & 0xFFFFFFFE)) {
            }
            InboundClient inboundClient = new InboundClient(this, localHandler, id);
            this.inboundClients.put(id, (Object)inboundClient);
        }
        return new UnsentRequestHandlerConnector(id, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() throws IOException {
        Object object;
        try {
            this.remoteConnection.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object object2;
            Object var2_2 = null;
            for (IntKeyMap.Entry entry : this.outboundClients) {
                OutboundClient outboundClient = (OutboundClient)entry.getValue();
                object2 = outboundClient;
                synchronized (object2) {
                    IoUtils.safeClose((Closeable)outboundClient.getRequestHandler());
                }
            }
            for (IntKeyMap.Entry entry : this.inboundClients) {
                InboundClient inboundClient = (InboundClient)entry.getValue();
                object2 = inboundClient;
                synchronized (object2) {
                    IoUtils.safeClose((Closeable)inboundClient.getHandler());
                }
            }
            for (IntKeyMap.Entry entry : this.outboundRequests) {
                OutboundRequest outboundRequest = (OutboundRequest)entry.getValue();
                object2 = outboundRequest;
                synchronized (object2) {
                    SpiUtils.safeHandleException(outboundRequest.getInboundReplyHandler(), (IOException)new IndeterminateOutcomeException("Connection closed"));
                }
            }
            for (IntKeyMap.Entry entry : this.inboundRequests) {
                InboundRequest inboundRequest = (InboundRequest)entry.getValue();
                object2 = inboundRequest;
                synchronized (object2) {
                    inboundRequest.getCancellable().cancel();
                }
            }
            throw throwable;
        }
        for (IntKeyMap.Entry entry : this.outboundClients) {
            OutboundClient outboundClient = (OutboundClient)entry.getValue();
            object = outboundClient;
            synchronized (object) {
                IoUtils.safeClose((Closeable)outboundClient.getRequestHandler());
            }
        }
        for (IntKeyMap.Entry entry : this.inboundClients) {
            InboundClient inboundClient = (InboundClient)entry.getValue();
            object = inboundClient;
            synchronized (object) {
                IoUtils.safeClose((Closeable)inboundClient.getHandler());
            }
        }
        for (IntKeyMap.Entry entry : this.outboundRequests) {
            OutboundRequest outboundRequest = (OutboundRequest)entry.getValue();
            object = outboundRequest;
            synchronized (object) {
                SpiUtils.safeHandleException(outboundRequest.getInboundReplyHandler(), (IOException)new IndeterminateOutcomeException("Connection closed"));
            }
        }
        for (IntKeyMap.Entry entry : this.inboundRequests) {
            InboundRequest inboundRequest = (InboundRequest)entry.getValue();
            object = inboundRequest;
            synchronized (object) {
                inboundRequest.getCancellable().cancel();
            }
        }
    }

    Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    MarshallerFactory getMarshallerFactory() {
        return this.marshallerFactory;
    }

    MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfiguration;
    }

    ConnectionHandlerContext getConnectionContext() {
        return this.connectionContext;
    }

    Random getRandom() {
        return this.random;
    }

    IntKeyMap<OutboundClient> getOutboundClients() {
        return this.outboundClients;
    }

    IntKeyMap<InboundClient> getInboundClients() {
        return this.inboundClients;
    }

    IntKeyMap<OutboundRequest> getOutboundRequests() {
        return this.outboundRequests;
    }

    IntKeyMap<InboundRequest> getInboundRequests() {
        return this.inboundRequests;
    }

    IntKeyMap<OutboundStream> getOutboundStreams() {
        return this.outboundStreams;
    }

    IntKeyMap<InboundStream> getInboundStreams() {
        return this.inboundStreams;
    }

    RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    static RemoteConnectionHandler getCurrent() {
        return current.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteConnectionHandler setCurrent(RemoteConnectionHandler newCurrent) {
        ThreadLocal<RemoteConnectionHandler> current = RemoteConnectionHandler.current;
        try {
            RemoteConnectionHandler remoteConnectionHandler = current.get();
            Object var4_3 = null;
            current.set(newCurrent);
            return remoteConnectionHandler;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            current.set(newCurrent);
            throw throwable;
        }
    }
}

