/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.SaslUtils;
import org.jboss.remoting3.remote.ServerAuthenticationHandler;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerInitialAuthenticationHandler
extends AbstractMessageHandler {
    private final RemoteConnection remoteConnection;
    private final Map<String, ?> saslPropertyMap;
    private final Map<String, SaslServerFactory> allowedMechs;
    private final ServerAuthenticationProvider authenticationProvider;
    private final ConnectionProviderContext connectionProviderContext;
    private int retries;
    private static final Logger log = Loggers.serverSasl;

    ServerInitialAuthenticationHandler(RemoteConnection remoteConnection, Map<String, ?> saslPropertyMap, Map<String, SaslServerFactory> allowedMechs, ServerAuthenticationProvider authenticationProvider, ConnectionProviderContext connectionProviderContext) {
        super(remoteConnection);
        this.remoteConnection = remoteConnection;
        this.saslPropertyMap = saslPropertyMap;
        this.allowedMechs = allowedMechs;
        this.authenticationProvider = authenticationProvider;
        this.connectionProviderContext = connectionProviderContext;
        this.retries = remoteConnection.getOptionMap().get(RemotingOptions.AUTHENTICATION_RETRIES, 3);
    }

    public void handleMessage(ByteBuffer buffer) {
        switch (buffer.get()) {
            case 1: {
                try {
                    String name = Buffers.getModifiedUtf8((ByteBuffer)buffer);
                    SaslServerFactory serverFactory = this.allowedMechs.get(name);
                    if (serverFactory != null) {
                        byte[] resp;
                        log.trace("Selected SASL mechanism %s", (Object)name);
                        String realm = this.connectionProviderContext.getEndpoint().getName();
                        SaslServer server = serverFactory.createSaslServer(name, "remote", realm, this.saslPropertyMap, this.authenticationProvider.getCallbackHandler());
                        this.remoteConnection.setMessageHandler(new ServerAuthenticationHandler(this.remoteConnection, server, this.connectionProviderContext, this));
                        log.trace("Sending initial challenge");
                        try {
                            resp = server.evaluateResponse(SaslUtils.EMPTY);
                        }
                        catch (SaslException e) {
                            log.trace("Rejected invalid SASL response: %s", (Object)e);
                            this.rejectAuth();
                            return;
                        }
                        this.remoteConnection.sendAuthMessage((byte)2, resp);
                        return;
                    }
                    log.trace("Rejected invalid SASL mechanism %s", (Object)name);
                    this.rejectAuth();
                    return;
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)this.remoteConnection);
                    log.trace("Failed to send auth message: %s", (Object)e);
                    return;
                }
            }
        }
        log.warn("Server received invalid auth request message");
        IoUtils.safeClose((Closeable)this.remoteConnection);
    }

    void rejectAuth() throws IOException {
        this.remoteConnection.sendAuthReject("Authentication failed");
        if (this.retries-- == 0) {
            this.remoteConnection.terminate();
        }
    }
}

