/* menu_data.c: menu structure for Fuse
   Copyright (c) 2004-2007 Philip Kendall, Stuart Brady, Marek Januszewski

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* This file is autogenerated from menu_data.dat by ../../../ui/widget/../../menu_data.pl.
   Any changes made here will not be preserved. */

#include <config.h>

#include "menu.h"

#include "input.h"
#include "options_internals.h"
#include "widget_internals.h"

static widget_menu_entry menu_file_recording[] = {
  { "Recording" },
  { "\012R\011ecord...", INPUT_KEY_r, NULL, menu_file_recording_record, NULL, 0 },
  { "Record \012f\011rom snapshot...", INPUT_KEY_f, NULL, menu_file_recording_recordfromsnapshot, NULL, 0 },
  { "\012I\011nsert snapshot", INPUT_KEY_i, NULL, menu_file_recording_insertsnapshot, NULL, 0 },
  { "Roll\012b\011ack", INPUT_KEY_b, NULL, menu_file_recording_rollback, NULL, 0 },
  { "Rollback \012t\011o...", INPUT_KEY_t, NULL, menu_file_recording_rollbackto, NULL, 0 },
  { "\012P\011lay...", INPUT_KEY_p, NULL, menu_file_recording_play, NULL, 0 },
  { "\012S\011top", INPUT_KEY_s, NULL, menu_file_recording_stop, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_file_aylogging[] = {
  { "AY Logging" },
  { "\012R\011ecord...", INPUT_KEY_r, NULL, menu_file_aylogging_record, NULL, 0 },
  { "\012S\011top", INPUT_KEY_s, NULL, menu_file_aylogging_stop, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_file_movies[] = {
  { "Movies" },
  { "Record Movie as \012S\011CR...", INPUT_KEY_s, NULL, menu_file_movies_recordmovieasscr, NULL, 0 },
  { "Record Movie as \012P\011NG...", INPUT_KEY_p, NULL, menu_file_movies_recordmovieaspng, NULL, 0 },
  { "S\012t\011op Movie Recording", INPUT_KEY_t, NULL, menu_file_movies_stopmovierecording, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_file[] = {
  { "File" },
  { "\012O\011pen...", INPUT_KEY_o, NULL, menu_file_open, NULL, 0 },
  { "\012S\011ave Snapshot...", INPUT_KEY_s, NULL, menu_file_savesnapshot, NULL, 0 },
  { "\012R\011ecording", INPUT_KEY_r, menu_file_recording, NULL, NULL, 0 },
  { "A\012Y\011 Logging", INPUT_KEY_y, menu_file_aylogging, NULL, NULL, 0 },
  { "O\012p\011en SCR Screenshot...", INPUT_KEY_p, NULL, menu_file_openscrscreenshot, NULL, 0 },
  { "S\012a\011ve Screen as SCR...", INPUT_KEY_a, NULL, menu_file_savescreenasscr, NULL, 0 },
  { "Save S\012c\011reen as PNG...", INPUT_KEY_c, NULL, menu_file_savescreenaspng, NULL, 0 },
  { "\012M\011ovies", INPUT_KEY_m, menu_file_movies, NULL, NULL, 0 },
  { "Loa\012d\011 binary data...", INPUT_KEY_d, NULL, menu_file_loadbinarydata, NULL, 0 },
  { "Save \012b\011inary data...", INPUT_KEY_b, NULL, menu_file_savebinarydata, NULL, 0 },
  { "E\012x\011it...", INPUT_KEY_x, NULL, menu_file_exit, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_options_joysticks[] = {
  { "Joysticks" },
  { "\012K\011eyboard...", INPUT_KEY_k, NULL, menu_options_joysticks_select, menu_keyboard_joystick_detail, 3 },
  { NULL }
};

static widget_menu_entry menu_options_selectroms[] = {
  { "Select ROMs" },
  { "Spectrum 1\0126\011K...", INPUT_KEY_6, NULL, menu_options_selectroms_select, NULL, 1 },
  { "Spectrum \0124\0118K...", INPUT_KEY_4, NULL, menu_options_selectroms_select, NULL, 2 },
  { "Spectrum \0121\01128K...", INPUT_KEY_1, NULL, menu_options_selectroms_select, NULL, 3 },
  { "Spectrum +\0122\011...", INPUT_KEY_2, NULL, menu_options_selectroms_select, NULL, 4 },
  { "Spectrum +2\012A\011...", INPUT_KEY_a, NULL, menu_options_selectroms_select, NULL, 5 },
  { "Spectrum +\0123\011...", INPUT_KEY_3, NULL, menu_options_selectroms_select, NULL, 6 },
  { "Spectrum +3\012e\011...", INPUT_KEY_e, NULL, menu_options_selectroms_select, NULL, 7 },
  { "Timex \012T\011C2048...", INPUT_KEY_t, NULL, menu_options_selectroms_select, NULL, 8 },
  { "Timex TC206\0128\011...", INPUT_KEY_8, NULL, menu_options_selectroms_select, NULL, 9 },
  { "Ti\012m\011ex TS2068...", INPUT_KEY_m, NULL, menu_options_selectroms_select, NULL, 10 },
  { "\012P\011entagon 128K...", INPUT_KEY_p, NULL, menu_options_selectroms_select, NULL, 11 },
  { "Pe\012n\011tagon 512K...", INPUT_KEY_n, NULL, menu_options_selectroms_select, NULL, 12 },
  { "Penta\012g\011on 1024K...", INPUT_KEY_g, NULL, menu_options_selectroms_select, NULL, 13 },
  { "S\012c\011orpion ZS 256...", INPUT_KEY_c, NULL, menu_options_selectroms_select, NULL, 14 },
  { "Spectrum \012S\011E...", INPUT_KEY_s, NULL, menu_options_selectroms_select, NULL, 15 },
  { "Interface \012I\011...", INPUT_KEY_i, NULL, menu_options_selectroms_select, NULL, 16 },
  { "\012B\011eta 128...", INPUT_KEY_b, NULL, menu_options_selectroms_select, NULL, 17 },
  { "+\012D\011...", INPUT_KEY_d, NULL, menu_options_selectroms_select, NULL, 18 },
  { NULL }
};

static widget_menu_entry menu_options[] = {
  { "Options" },
  { "\012G\011eneral...", INPUT_KEY_g, NULL, menu_options_general, NULL, 0 },
  { "\012S\011ound...", INPUT_KEY_s, NULL, menu_options_sound, NULL, 0 },
  { "\012P\011eripherals...", INPUT_KEY_p, NULL, menu_options_peripherals, NULL, 0 },
  { "\012R\011ZX...", INPUT_KEY_r, NULL, menu_options_rzx, NULL, 0 },
  { "\012J\011oysticks", INPUT_KEY_j, menu_options_joysticks, NULL, NULL, 0 },
  { "S\012e\011lect ROMs", INPUT_KEY_e, menu_options_selectroms, NULL, NULL, 0 },
  { "\012F\011ilter...", INPUT_KEY_f, NULL, menu_options_filter, menu_filter_detail, 0 },
  { "\012D\011isk options...", INPUT_KEY_d, NULL, menu_options_diskoptions, NULL, 0 },
  { "S\012a\011ve", INPUT_KEY_a, NULL, menu_options_save, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_machine_profiler[] = {
  { "Profiler" },
  { "\012S\011tart", INPUT_KEY_s, NULL, menu_machine_profiler_start, NULL, 0 },
  { "\012S\011top", INPUT_KEY_s, NULL, menu_machine_profiler_stop, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_machine[] = {
  { "Machine" },
  { "\012P\011ause...", INPUT_KEY_p, NULL, menu_machine_pause, NULL, 0 },
  { "\012R\011eset...", INPUT_KEY_r, NULL, menu_machine_reset, NULL, 0 },
  { "\012H\011ard reset...", INPUT_KEY_h, NULL, menu_machine_reset, NULL, 1 },
  { "\012S\011elect...", INPUT_KEY_s, NULL, menu_machine_select, menu_machine_detail, 0 },
  { "\012D\011ebugger...", INPUT_KEY_d, NULL, menu_machine_debugger, NULL, 0 },
  { "P\012o\011ke Finder...", INPUT_KEY_o, NULL, menu_machine_pokefinder, NULL, 0 },
  { "\012M\011emory Browser...", INPUT_KEY_m, NULL, menu_machine_memorybrowser, NULL, 0 },
  { "Pro\012f\011iler", INPUT_KEY_f, menu_machine_profiler, NULL, NULL, 0 },
  { "\012N\011MI", INPUT_KEY_n, NULL, menu_machine_nmi, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_tape[] = {
  { "Tape" },
  { "\012O\011pen...", INPUT_KEY_o, NULL, menu_media_tape_open, NULL, 0 },
  { "\012P\011lay", INPUT_KEY_p, NULL, menu_media_tape_play, NULL, 0 },
  { "\012B\011rowse...", INPUT_KEY_b, NULL, menu_media_tape_browse, NULL, 0 },
  { "\012R\011ewind", INPUT_KEY_r, NULL, menu_media_tape_rewind, NULL, 0 },
  { "\012C\011lear", INPUT_KEY_c, NULL, menu_media_tape_clear, NULL, 0 },
  { "\012W\011rite...", INPUT_KEY_w, NULL, menu_media_tape_write, NULL, 0 },
  { "R\012e\011cord Start", INPUT_KEY_e, NULL, menu_media_tape_recordstart, NULL, 0 },
  { "Recor\012d\011 Stop", INPUT_KEY_d, NULL, menu_media_tape_recordstop, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive1_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x131 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x031 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive1[] = {
  { "Microdrive 1" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x31 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x31 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x031 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x231 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x131 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive1_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive2_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x132 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x032 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive2[] = {
  { "Microdrive 2" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x32 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x32 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x032 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x232 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x132 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive2_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive3_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x133 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x033 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive3[] = {
  { "Microdrive 3" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x33 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x33 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x033 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x233 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x133 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive3_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive4_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x134 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x034 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive4[] = {
  { "Microdrive 4" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x34 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x34 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x034 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x234 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x134 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive4_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive5_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x135 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x035 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive5[] = {
  { "Microdrive 5" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x35 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x35 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x035 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x235 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x135 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive5_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive6_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x136 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x036 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive6[] = {
  { "Microdrive 6" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x36 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x36 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x036 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x236 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x136 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive6_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive7_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x137 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x037 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive7[] = {
  { "Microdrive 7" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x37 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x37 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x037 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x237 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x137 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive7_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive8_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x138 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x038 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive8[] = {
  { "Microdrive 8" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x38 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x38 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x038 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x238 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x138 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_interfacei_microdrive8_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_rs232[] = {
  { "RS232" },
  { "Plug \012R\011xD", INPUT_KEY_r, NULL, menu_media_if1_rs232, NULL, 0x01 },
  { "\012U\011nplug RxD", INPUT_KEY_u, NULL, menu_media_if1_rs232, NULL, 0x11 },
  { "Plug \012T\011xD", INPUT_KEY_t, NULL, menu_media_if1_rs232, NULL, 0x02 },
  { "Un\012p\011lug TxD", INPUT_KEY_p, NULL, menu_media_if1_rs232, NULL, 0x12 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei[] = {
  { "Interface I" },
  { "Microdrive \0121\011", INPUT_KEY_1, menu_media_interfacei_microdrive1, NULL, NULL, 0 },
  { "Microdrive \0122\011", INPUT_KEY_2, menu_media_interfacei_microdrive2, NULL, NULL, 0 },
  { "Microdrive \0123\011", INPUT_KEY_3, menu_media_interfacei_microdrive3, NULL, NULL, 0 },
  { "Microdrive \0124\011", INPUT_KEY_4, menu_media_interfacei_microdrive4, NULL, NULL, 0 },
  { "Microdrive \0125\011", INPUT_KEY_5, menu_media_interfacei_microdrive5, NULL, NULL, 0 },
  { "Microdrive \0126\011", INPUT_KEY_6, menu_media_interfacei_microdrive6, NULL, NULL, 0 },
  { "Microdrive \0127\011", INPUT_KEY_7, menu_media_interfacei_microdrive7, NULL, NULL, 0 },
  { "Microdrive \0128\011", INPUT_KEY_8, menu_media_interfacei_microdrive8, NULL, NULL, 0 },
  { "\012R\011S232", INPUT_KEY_r, menu_media_interfacei_rs232, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_drivea_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x101 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x001 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_drivea_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x101 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x001 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_drivea[] = {
  { "Drive A:" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x01 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x01 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x01 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x201 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x101 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_3_drivea_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_3_drivea_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_driveb_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x102 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x002 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_driveb_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x102 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x002 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_driveb[] = {
  { "Drive B:" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x02 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x02 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x02 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x202 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x102 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_3_driveb_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_3_driveb_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3[] = {
  { "+3" },
  { "Drive \012A\011:", INPUT_KEY_a, menu_media_disk_3_drivea, NULL, menu_plus3a_detail, 0 },
  { "Drive \012B\011:", INPUT_KEY_b, menu_media_disk_3_driveb, NULL, menu_plus3b_detail, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drivea_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x111 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x011 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drivea_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x111 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x011 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drivea[] = {
  { "Drive A:" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x11 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x11 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x11 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x211 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x111 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_beta_drivea_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_beta_drivea_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_driveb_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x112 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x012 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_driveb_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x112 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x012 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_driveb[] = {
  { "Drive B:" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x12 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x12 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x012 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x212 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x112 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_beta_driveb_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_beta_driveb_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drivec_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x113 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x013 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drivec_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x113 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x013 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drivec[] = {
  { "Drive C:" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x13 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x13 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x013 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x213 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x113 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_beta_drivec_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_beta_drivec_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drived_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x114 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x014 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drived_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x114 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x014 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta_drived[] = {
  { "Drive D:" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x14 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x14 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x014 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x214 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x114 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_beta_drived_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_beta_drived_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_beta[] = {
  { "Beta" },
  { "Drive \012A\011:", INPUT_KEY_a, menu_media_disk_beta_drivea, NULL, menu_beta128a_detail, 0 },
  { "Drive \012B\011:", INPUT_KEY_b, menu_media_disk_beta_driveb, NULL, menu_beta128b_detail, 0 },
  { "Drive \012C\011:", INPUT_KEY_c, menu_media_disk_beta_drivec, NULL, menu_beta128c_detail, 0 },
  { "Drive \012D\011:", INPUT_KEY_d, menu_media_disk_beta_drived, NULL, menu_beta128d_detail, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_d_drive1_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x121 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x021 },
  { NULL }
};

static widget_menu_entry menu_media_disk_d_drive1_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x121 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x021 },
  { NULL }
};

static widget_menu_entry menu_media_disk_d_drive1[] = {
  { "Drive 1" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x21 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x21 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x021 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x221 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x121 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_d_drive1_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_d_drive1_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_d_drive2_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x122 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x022 },
  { NULL }
};

static widget_menu_entry menu_media_disk_d_drive2_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x122 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x022 },
  { NULL }
};

static widget_menu_entry menu_media_disk_d_drive2[] = {
  { "Drive 2" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x22 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x22 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x022 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x222 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x122 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_d_drive2_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_d_drive2_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_d[] = {
  { "+D" },
  { "Drive \0121\011", INPUT_KEY_1, menu_media_disk_d_drive1, NULL, menu_plusd1_detail, 0 },
  { "Drive \0122\011", INPUT_KEY_2, menu_media_disk_d_drive2, NULL, menu_plusd2_detail, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_opus_drive1_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x141 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x041 },
  { NULL }
};

static widget_menu_entry menu_media_disk_opus_drive1_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x141 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x041 },
  { NULL }
};

static widget_menu_entry menu_media_disk_opus_drive1[] = {
  { "Drive 1" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x41 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x41 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x041 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x241 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x141 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_opus_drive1_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_opus_drive1_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_opus_drive2_flipdisk[] = {
  { "Flip disk" },
  { "Turn \012u\011pside down", INPUT_KEY_u, NULL, menu_media_flip, NULL, 0x142 },
  { "Turn \012b\011ack", INPUT_KEY_b, NULL, menu_media_flip, NULL, 0x042 },
  { NULL }
};

static widget_menu_entry menu_media_disk_opus_drive2_writeprotect[] = {
  { "Write protect" },
  { "\012E\011nable", INPUT_KEY_e, NULL, menu_media_writeprotect, NULL, 0x142 },
  { "\012D\011isable", INPUT_KEY_d, NULL, menu_media_writeprotect, NULL, 0x042 },
  { NULL }
};

static widget_menu_entry menu_media_disk_opus_drive2[] = {
  { "Drive 2" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_insert_new, NULL, 0x42 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_insert, NULL, 0x42 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_eject, NULL, 0x042 },
  { "\012S\011ave", INPUT_KEY_s, NULL, menu_media_eject, NULL, 0x242 },
  { "Save \012A\011s...", INPUT_KEY_a, NULL, menu_media_eject, NULL, 0x142 },
  { "\012F\011lip disk", INPUT_KEY_f, menu_media_disk_opus_drive2_flipdisk, NULL, NULL, 0 },
  { "Write \012p\011rotect", INPUT_KEY_p, menu_media_disk_opus_drive2_writeprotect, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_opus[] = {
  { "Opus" },
  { "Drive \0121\011", INPUT_KEY_1, menu_media_disk_opus_drive1, NULL, menu_opus1_detail, 0 },
  { "Drive \0122\011", INPUT_KEY_2, menu_media_disk_opus_drive2, NULL, menu_opus2_detail, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk[] = {
  { "Disk" },
  { "+\0123\011", INPUT_KEY_3, menu_media_disk_3, NULL, NULL, 0 },
  { "\012B\011eta", INPUT_KEY_b, menu_media_disk_beta, NULL, NULL, 0 },
  { "+\012D\011", INPUT_KEY_d, menu_media_disk_d, NULL, NULL, 0 },
  { "\012O\011pus", INPUT_KEY_o, menu_media_disk_opus, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge_timexdock[] = {
  { "Timex Dock" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_cartridge_timexdock_insert, NULL, 0 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_cartridge_timexdock_eject, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge_interfaceii[] = {
  { "Interface II" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_cartridge_interfaceii_insert, NULL, 0 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_cartridge_interfaceii_eject, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge[] = {
  { "Cartridge" },
  { "\012T\011imex Dock", INPUT_KEY_t, menu_media_cartridge_timexdock, NULL, NULL, 0 },
  { "\012I\011nterface II", INPUT_KEY_i, menu_media_cartridge_interfaceii, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit_master[] = {
  { "Master" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, NULL, 1 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, NULL, 1 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, NULL, 1 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit_slave[] = {
  { "Slave" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, NULL, 2 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, NULL, 2 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, NULL, 2 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit[] = {
  { "Simple 8-bit" },
  { "\012M\011aster", INPUT_KEY_m, menu_media_ide_simple8bit_master, NULL, NULL, 0 },
  { "\012S\011lave", INPUT_KEY_s, menu_media_ide_simple8bit_slave, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp_master[] = {
  { "Master" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, NULL, 3 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, NULL, 3 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, NULL, 3 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp_slave[] = {
  { "Slave" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, NULL, 4 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, NULL, 4 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, NULL, 4 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp[] = {
  { "ZXATASP" },
  { "\012M\011aster", INPUT_KEY_m, menu_media_ide_zxatasp_master, NULL, NULL, 0 },
  { "\012S\011lave", INPUT_KEY_s, menu_media_ide_zxatasp_slave, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxcfcompactflash[] = {
  { "ZXCF CompactFlash" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, NULL, 5 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, NULL, 5 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, NULL, 5 },
  { NULL }
};

static widget_menu_entry menu_media_ide_divide_master[] = {
  { "Master" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, NULL, 6 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, NULL, 6 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, NULL, 6 },
  { NULL }
};

static widget_menu_entry menu_media_ide_divide_slave[] = {
  { "Slave" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, NULL, 7 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, NULL, 7 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, NULL, 7 },
  { NULL }
};

static widget_menu_entry menu_media_ide_divide[] = {
  { "DivIDE" },
  { "\012M\011aster", INPUT_KEY_m, menu_media_ide_divide_master, NULL, NULL, 0 },
  { "\012S\011lave", INPUT_KEY_s, menu_media_ide_divide_slave, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide[] = {
  { "IDE" },
  { "Simple \0128\011-bit", INPUT_KEY_8, menu_media_ide_simple8bit, NULL, NULL, 0 },
  { "ZX\012A\011TASP", INPUT_KEY_a, menu_media_ide_zxatasp, NULL, NULL, 0 },
  { "ZX\012C\011F CompactFlash", INPUT_KEY_c, menu_media_ide_zxcfcompactflash, NULL, NULL, 0 },
  { "\012D\011ivIDE", INPUT_KEY_d, menu_media_ide_divide, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media[] = {
  { "Media" },
  { "\012T\011ape", INPUT_KEY_t, menu_media_tape, NULL, menu_tape_detail, 0 },
  { "\012I\011nterface I", INPUT_KEY_i, menu_media_interfacei, NULL, NULL, 0 },
  { "\012D\011isk", INPUT_KEY_d, menu_media_disk, NULL, NULL, 0 },
  { "\012C\011artridge", INPUT_KEY_c, menu_media_cartridge, NULL, NULL, 0 },
  { "ID\012E\011", INPUT_KEY_e, menu_media_ide, NULL, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_help[] = {
  { "Help" },
  { "\012K\011eyboard...", INPUT_KEY_k, NULL, menu_help_keyboard, NULL, 0 },
  { "\012A\011bout...", INPUT_KEY_a, NULL, menu_help_about, NULL, 0 },
  { NULL }
};

widget_menu_entry widget_menu[] = {
  { "Main menu" },
  { "\012F\011ile", INPUT_KEY_f, menu_file, NULL, NULL, 0 },
  { "\012O\011ptions", INPUT_KEY_o, menu_options, NULL, NULL, 0 },
  { "\012M\011achine", INPUT_KEY_m, menu_machine, NULL, NULL, 0 },
  { "M\012e\011dia", INPUT_KEY_e, menu_media, NULL, NULL, 0 },
  { "\012H\011elp", INPUT_KEY_h, menu_help, NULL, NULL, 0 },
  { NULL }
};

