/***************************************************************************
 * libgsft: Common functions.                                              *
 * gsft_strdup.c: strdup() implementation for older systems.               *
 *                                                                         *
 * Copyright (c) 2008-2009 by David Korth                                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at your  *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.           *
 ***************************************************************************/

#ifndef __GSFT_STRDUP_H
#define __GSFT_STRDUP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STRDUP

/* strdup() is defined. */
#include <string.h>

#else /* !HAVE_STRDUP */

#ifdef __cplusplus
extern "C" {
#endif

char* strdup(const char *s);

#ifdef __cplusplus
}
#endif

#endif /* HAVE_STRDUP */

#endif /* __GSFT_STRDUP_H */
