//  $Id: panel.hpp 3081 2007-09-05 02:11:34Z grumbel $
//
//  Pingus - A free Lemmings clone
//  Copyright (C) 2007 Jason Green <jave27@gmail.com>,
//                     Ingo Ruhnke <grumbel@gmx.de>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef HEADER_PINGUS_EDITOR_PANEL_HXX
#define HEADER_PINGUS_EDITOR_PANEL_HXX

#include <string>
#include "sprite.hpp"
#include "math/vector2i.hpp"
#include "../gui/component.hpp"

namespace Editor {

class EditorScreen;

/** */
class Panel : public GUI::Component
{
private:
  EditorScreen* editor;
  Sprite logo;
  Vector2i pos;

  typedef void (EditorScreen::*Callback)();
  Callback callback;

public:
  Panel(EditorScreen* e);
  ~Panel();

  void draw (DrawingContext& gc);
  void update (float delta);

  void add_button(const std::string& image, const std::string& tooltip = "", Callback callback = 0);
  void add_toggle_button(const std::string& image);
  void add_separator();
  
private:
  Panel (const Panel&);
  Panel& operator= (const Panel&);
};

} // namespace Editor

#endif

/* EOF */
