'''OpenGL extension VERSION.GL_1_4

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_1_4 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_1_4.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.VERSION.GL_1_4 import *
### END AUTOGENERATED SECTION
from OpenGL.lazywrapper import lazy
from OpenGL.GL.pointers import glDrawElements
#glMultiDrawElements = wrapper.wrapper( glMultiDrawElements ).setPyConverter(
#	'indices', arrays.AsArrayOfType( 'indices', 'type' ),
#).setCResolver( 
#	'indices', arrays.ArrayDatatype.voidDataPointer ,
#).setPyConverter(
#	'count', arrays.AsArrayTyped( 'count', arrays.GLsizeiArray ),
#).setCResolver(
#	'count', arrays.ArrayDatatype.voidDataPointer ,
#)

@lazy( glMultiDrawElements )
def glMultiDrawElements(baseOperation, primtype, counts, typ, indices, primcount=None):
    """Currently glMultiDrawElements is not working in the wrapper 
    
    We are replacing the code with a sequence of glDrawElements calls
    as per the spec for the function.  Basically we'd spend more effort
    making an array of array pointers than we would creating a simple
    iteration in Python.
    """
    if primcount is not None:
        for i in xrange( primcount ):
            glDrawElements( primtype, counts[i], typ, indices[i] )
    else:
        for c,i in zip( counts, indices ):
            glDrawElements( primtype, c, typ, i )