/*
 * chttpd/1.0   
 *  config file reader.
 *  copyright (c) 0x7d0 
 *  Greg Olszewski <noop@nwonknu.org>
 *  
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <log.h>
#include <config.h>


struct opts {
    char           *opt;
    size_t          len;
};

int
read_config(char *configfilename, int *portnum, char **webdirprefix)
{
    const struct opts options[] = {
	{"BASEDIR", 6},
	{"ERRLOG", 6},
	{"LOGFILE", 7},
	{"PORT", 4}
    };

    FILE           *configfile;

    char            buffer[1024],
                    infofile[1024],
                    errfile[1024],
                   *tester,
                   *buf;

    int             i,
                    errlog = 0,
                    numopts = 4;

    errfile[0] = '\0';
    infofile[0] = '\0';

    configfile = fopen(configfilename, "r+");
    if (!configfile) {
	fprintf(stderr, "Couldn't open config file: %s\n", configfilename);

	return (1);
    }
    while ((tester = fgets(buffer, 1023, configfile))) {
	if (!strchr(buffer, '\n')) {
	    fprintf(stderr,
		    "Go hack the source, We only have lines 1024 long\
							 now");
	    fclose(configfile);
	    return 2;
	}
	if (!tester) {
	    fclose(configfile);
	    return 2;
	}
	if ((buffer[0] == '\n' || buffer[0] == '#')) {
	    continue;		/*
				 * skip blank lines and lines that start with # 
				 */
	}
	for (i = 0; i < numopts; i++) {
	    if (!strncmp(options[i].opt, buffer, options[i].len)) {
		printf("matched:%s\twith:%s", options[i].opt, buffer);
		break;		/*
				 * check known options 
				 */
	    }
	}
	buf = buffer;
	while (!isspace(*buf))
	    buf++;
	while (isspace(*buf) && *buf)
	    buf++;		/*
				 * skip past options 
				 */
	if (!*buf || *buf == '\n') {
	    fprintf(stderr, "option %s require argument", options[i].opt);
	    fclose(configfile);
	    return 2;
	}
	switch (i) {
	case 0:		/*
			 * basedir
			 */
	    *webdirprefix =
		(char *) malloc((sizeof(char)) * (strlen(buf)));
	    strcpy(*webdirprefix, buf);
	    if ((buf = strchr(*webdirprefix, '\n')))
		*buf = '\0';
	    break;
	case 1:		/*
			 * errlog
			 */
	    if (!strncmp(buf, "SYSLOG", 6) || !strncmp(buf, "syslog", 6))
		errlog = ERRSYSLOG;
	    if (!strncmp(buf, "FILE", 4) || !strncmp(buf, "file", 4)) {
		errlog = ERRFILE;
		while (!isspace(*buf) && (*buf))
		    buf++;
		while (isspace(*buf) && (*buf))
		    buf++;
		if (!buf) {
		    fprintf(stderr, "couldn't find error file\n");
		    fclose(configfile);
		    return 2;
		}
		strcpy(errfile, buf);
		if ((buf = strchr(errfile, '\n')))
		    *buf = '\0';
	    }
	    break;
	case 2:		/*
			 * logfile
			 */
	    strcpy(infofile, buf);
	    if ((buf = strchr(infofile, '\n')))
		*buf = '\0';
	    break;
	case 3:		/*
			 * portnum
			 */
	    if (portnum)
		sscanf(buf, "%i", portnum);
	    break;
	default:
	    fprintf(stderr, "unknown option in config:%s\n", buffer);
	    fclose(configfile);
	    return 2;
	}
    }
    fclose(configfile);
    return (init_log(errlog, infofile, errfile)*2);
}
