/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDTTools {
    private static final IJavaElement[] EMPTY_JAVA_ELEMENT_ARRAY = new IJavaElement[0];
    private static final Filter<IPackageFragmentRoot> SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER = new Filter<IPackageFragmentRoot>(){

        public boolean accept(IPackageFragmentRoot pfr) {
            return JDTTools.packageFragmentRootIsSourceFolder(pfr);
        }
    };
    private static final String SERIALIZABLE_CLASS_NAME = Serializable.class.getName();
    private static final String[] VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    private static final String[] OTHER_VALID_BASIC_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};

    public static boolean packageFragmentRootIsSourceFolder(IPackageFragmentRoot pfr) {
        try {
            return JDTTools.packageFragmentRootIsSourceFolder_(pfr);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    static boolean packageFragmentRootIsSourceFolder_(IPackageFragmentRoot pfr) throws JavaModelException {
        return pfr.exists() && pfr.getKind() == 1;
    }

    public static IJavaElement[] getChildren(IParent parent) {
        try {
            return parent.getChildren();
        }
        catch (JavaModelException ex) {
            if (!(ex.getCause() instanceof FileNotFoundException)) {
                JptCommonCorePlugin.log(ex);
            }
            return EMPTY_JAVA_ELEMENT_ARRAY;
        }
    }

    public static boolean typeNamedImplementsInterfaceNamed(IJavaProject javaProject, String typeName, String interfaceName) {
        try {
            return JDTTools.typeImplementsInterface(javaProject, javaProject.findType(typeName), javaProject.findType(interfaceName));
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    private static boolean typeImplementsInterfaceNamed(IJavaProject javaProject, IType type, String interfaceName) throws JavaModelException {
        return JDTTools.typeImplementsInterface(javaProject, type, javaProject.findType(interfaceName));
    }

    private static boolean typeImplementsInterface(IJavaProject javaProject, IType type, IType interfase) throws JavaModelException {
        if (type == null || interfase == null) {
            return false;
        }
        String interfaceName = interfase.getFullyQualifiedName();
        for (String superInterfaceName : JDTTools.resolveSuperInterfaceNames(type)) {
            if (superInterfaceName.equals(interfaceName)) {
                return true;
            }
            if (!JDTTools.typeImplementsInterface(javaProject, javaProject.findType(superInterfaceName), interfase)) continue;
            return true;
        }
        if (type.getSuperclassName() == null) {
            return false;
        }
        return JDTTools.typeImplementsInterface(javaProject, javaProject.findType(JDTTools.resolveSuperclassName(type)), interfase);
    }

    private static Iterable<String> resolveSuperInterfaceNames(IType type) throws JavaModelException {
        if (type.isBinary()) {
            return new ArrayIterable((Object[])type.getSuperInterfaceNames());
        }
        ArrayList<String> resolvedSuperInterfaceNames = new ArrayList<String>();
        String[] stringArray = type.getSuperInterfaceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String superInterfaceName = stringArray[n2];
            resolvedSuperInterfaceNames.add(JDTTools.resolveType(type, superInterfaceName));
            ++n2;
        }
        return resolvedSuperInterfaceNames;
    }

    private static String resolveSuperclassName(IType type) throws JavaModelException {
        return type.isBinary() ? type.getSuperclassName() : JDTTools.resolveType(type, type.getSuperclassName());
    }

    private static String resolveType(IType type, String className) throws JavaModelException {
        String[][] resolvedClassNames = type.resolveType(className);
        if (resolvedClassNames == null) {
            return null;
        }
        String pkg = resolvedClassNames[0][0];
        String cls = resolvedClassNames[0][1];
        return pkg.length() == 0 ? cls : String.valueOf(pkg) + '.' + cls;
    }

    public static IType findType(IJavaProject javaProject, String fullyQualifiedName) {
        try {
            return javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    public static Iterable<IPackageFragmentRoot> getJavaSourceFolders(IJavaProject javaProject) {
        return new FilteringIterable(JDTTools.getPackageFragmentRoots(javaProject), SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER);
    }

    private static Iterable<IPackageFragmentRoot> getPackageFragmentRoots(IJavaProject javaProject) {
        try {
            return JDTTools.getPackageFragmentRoots_(javaProject);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EmptyIterable.instance();
        }
    }

    private static Iterable<IPackageFragmentRoot> getPackageFragmentRoots_(IJavaProject javaProject) throws JavaModelException {
        return new ArrayIterable((Object[])javaProject.getPackageFragmentRoots());
    }

    public static boolean typeIsBasic(IJavaProject javaProject, String fullyQualifiedName) {
        try {
            return JDTTools.typeIsBasic(javaProject, javaProject.findType(fullyQualifiedName));
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    private static boolean typeIsBasic(IJavaProject javaProject, IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        String fullyQualifiedName = type.getFullyQualifiedName();
        if (fullyQualifiedName == null) {
            return false;
        }
        int arrayDepth = ReflectionTools.getArrayDepthForTypeDeclaration((String)fullyQualifiedName);
        if (arrayDepth > 1) {
            return false;
        }
        if (arrayDepth == 1) {
            String elementTypeName = ReflectionTools.getElementTypeNameForTypeDeclaration((String)fullyQualifiedName, (int)1);
            return JDTTools.elementTypeIsValidForBasicArray(elementTypeName);
        }
        if (ClassName.isVariablePrimitive((String)fullyQualifiedName)) {
            return true;
        }
        if (ClassName.isVariablePrimitiveWrapper((String)fullyQualifiedName)) {
            return true;
        }
        if (JDTTools.typeIsOtherValidBasicType(fullyQualifiedName)) {
            return true;
        }
        if (JDTTools.typeImplementsInterfaceNamed(javaProject, type, SERIALIZABLE_CLASS_NAME)) {
            return true;
        }
        return type.isEnum();
    }

    public static boolean elementTypeIsValidForBasicArray(String elementTypeName) {
        return ArrayTools.contains((Object[])VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    public static boolean typeIsOtherValidBasicType(String typeName) {
        return ArrayTools.contains((Object[])OTHER_VALID_BASIC_TYPE_NAMES, (Object)typeName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean classHasPublicZeroArgConstructor(IJavaProject javaProject, String className) {
        if (javaProject == null) return false;
        if (className == null) return false;
        IType type = JDTTools.findType(javaProject, className);
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMethod method = iMethodArray[n2];
                if (method.isConstructor() && method.getNumberOfParameters() == 0 && method.getFlags() == 1) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
        }
        return false;
    }
}

