/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.Enum;
import org.eclipse.jpt.common.core.utility.jdt.EnumConstant;
import org.eclipse.jpt.common.utility.CommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTEnumConstant
extends JDTMember
implements EnumConstant {
    public JDTEnumConstant(Enum declaringEnum, String name, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(declaringEnum, name, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    public JDTEnumConstant(Enum declaringEnum, String name, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringEnum, name, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
    }

    public JDTEnumConstant(Enum declaringEnum, String name, int occurrence, ICompilationUnit compilationUnit) {
        this(declaringEnum, name, occurrence, compilationUnit, CommandExecutor.Default.instance(), (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    @Override
    protected Enum getDeclaringType() {
        return (Enum)super.getDeclaringType();
    }

    @Override
    public IVariableBinding getBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).resolveVariable();
    }

    @Override
    public EnumConstantDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        return this.getSelectedDeclaration(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return new ASTNodeTextRange((ASTNode)this.getBodyDeclaration(astRoot).getName());
    }

    @Override
    public boolean isPersistable(CompilationUnit astRoot) {
        return true;
    }

    protected EnumConstantDeclaration getSelectedDeclaration(CompilationUnit astRoot) {
        String name = this.getName();
        int occurrence = this.getOccurrence();
        int count = 0;
        EnumConstantDeclaration[] enumConstantDeclarationArray = this.getDeclaringTypeEnumConstantDeclarations(astRoot);
        int n = enumConstantDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumConstantDeclaration enumConstantDeclaration = enumConstantDeclarationArray[n2];
            if (enumConstantDeclaration.getName().getFullyQualifiedName().equals(name) && ++count == occurrence) {
                return enumConstantDeclaration;
            }
            ++n2;
        }
        return null;
    }

    protected EnumConstantDeclaration[] getDeclaringTypeEnumConstantDeclarations(CompilationUnit astRoot) {
        List<EnumConstantDeclaration> enumConstants = JDTEnumConstant.enumConstants(this.getDeclaringTypeDeclaration(astRoot));
        return enumConstants.toArray(new EnumConstantDeclaration[enumConstants.size()]);
    }

    private static List<EnumConstantDeclaration> enumConstants(EnumDeclaration ed) {
        return ed.enumConstants();
    }

    protected EnumDeclaration getDeclaringTypeDeclaration(CompilationUnit astRoot) {
        return this.getDeclaringType().getBodyDeclaration(astRoot);
    }
}

