/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.TreeMap;
import org.eclipse.core.internal.resources.FilterDescriptor;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.filtermatchers.AbstractFileInfoMatcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.DefaultCustomFilterArgumentUI;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.internal.ide.dialogs.ICustomFilterArgumentUI;
import org.eclipse.ui.internal.ide.dialogs.MultiMatcherCustomFilterArgumentUI;
import org.eclipse.ui.internal.ide.dialogs.ResourceFilterGroup;

class FilterEditDialog
extends TrayDialog {
    private FilterCopy filter;
    protected Button filesButton;
    protected Button foldersButton;
    protected Button filesAndFoldersButton;
    protected Combo idCombo;
    protected Composite idComposite;
    protected Button includeButton;
    protected Button excludeButton;
    protected Composite argumentComposite;
    protected Button inherited;
    protected FilterTypeUtil util;
    protected boolean createGroupOnly;
    protected boolean creatingNewFilter;
    protected ResourceFilterGroup filterGroup;
    protected IResource resource;
    TreeMap customfilterArgumentMap = new TreeMap();
    ICustomFilterArgumentUI currentCustomFilterArgumentUI = new ICustomFilterArgumentUI(){

        public Object getID() {
            return "dummy";
        }

        public void create(Composite argumentComposite, Font font) {
        }

        public void dispose() {
        }

        public void selectionChanged() {
        }

        public String validate() {
            return null;
        }

        public StyledString formatStyledText(FilterCopy filter, StyledString.Styler fPlainStyler, StyledString.Styler fBoldStyler) {
            return null;
        }
    };

    public FilterEditDialog(IResource resource, ResourceFilterGroup filterGroup, Shell parentShell, FilterCopy filter, boolean createGroupOnly, boolean creatingNewFilter) {
        super(parentShell);
        this.resource = resource;
        this.creatingNewFilter = creatingNewFilter;
        this.filterGroup = filterGroup;
        this.filter = filter;
        this.createGroupOnly = createGroupOnly;
        this.util = new FilterTypeUtil();
        ICustomFilterArgumentUI ui = new MultiMatcherCustomFilterArgumentUI(this, parentShell, filter);
        this.customfilterArgumentMap.put(ui.getID(), ui);
        ui = new DefaultCustomFilterArgumentUI(this, parentShell, filter);
        this.customfilterArgumentMap.put(ui.getID(), ui);
    }

    protected Control createDialogArea(Composite parent) {
        GridData data = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)data);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.ui.ide.edit_resource_filter_property_page_context");
        if (!this.filter.isUnderAGroupFilter()) {
            Composite topComposite = new Composite(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = 0;
            layout.marginBottom = 0;
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = 0;
            topComposite.setLayout((Layout)layout);
            data = new GridData(4, 4, true, false);
            topComposite.setLayoutData((Object)data);
            topComposite.setFont(font);
            this.createModeArea(font, topComposite);
            this.createTargetArea(font, topComposite);
            this.createIdArea(font, topComposite);
        } else {
            layout.marginHeight = this.convertHorizontalDLUsToPixels(7);
            this.createIdArea(font, composite);
        }
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite.setFont(parent.getFont());
        if (this.isHelpAvailable()) {
            Control helpControl = this.createHelpControl(composite);
            ((GridData)helpControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        }
        Control buttonSection = this.dialogCreateButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite;
    }

    private Control dialogCreateButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    private void createInheritableArea(Font font, Composite composite) {
        Composite inheritableComposite = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterMode, null), false, false, 1);
        GridLayout layout = (GridLayout)inheritableComposite.getLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.marginLeft = 0;
        inheritableComposite.setLayout((Layout)layout);
        this.inherited = new Button(inheritableComposite, 32);
        String label = IDEWorkbenchMessages.ResourceFilterPage_applyRecursivelyToFolderStructure;
        this.inherited.setText(NLS.bind((String)label, (Object)this.resource.getName()));
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 1;
        this.inherited.setLayoutData((Object)data);
        this.inherited.setFont(font);
        this.inherited.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.INHERITABLE, new Boolean(FilterEditDialog.this.inherited.getSelection()));
            }
        });
        this.inherited.setSelection(((Boolean)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.INHERITABLE)).booleanValue());
    }

    private void createModeArea(Font font, Composite composite) {
        Composite modeComposite = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterMode, null), true, true, 1);
        String[] modes = FilterTypeUtil.getModes();
        this.includeButton = new Button(modeComposite, 16);
        this.includeButton.setText(modes[0]);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.includeButton.setLayoutData((Object)data);
        this.includeButton.setFont(font);
        this.includeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.MODE, new Integer(0));
            }
        });
        this.includeButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.MODE) == 0);
        this.excludeButton = new Button(modeComposite, 16);
        this.excludeButton.setText(modes[1]);
        data = new GridData(4, 0x1000000, true, false);
        this.excludeButton.setLayoutData((Object)data);
        this.excludeButton.setFont(font);
        this.excludeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.MODE, new Integer(1));
            }
        });
        this.excludeButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.MODE) == 1);
    }

    private void createIdArea(Font font, Composite composite) {
        if (this.createGroupOnly) {
            this.idComposite = this.createGroup(font, composite, new String(), true, true, 1);
            this.createMatcherCombo(this.idComposite, font);
            GridData data = new GridData(4, 0x1000000, true, false);
            this.idCombo.setLayoutData((Object)data);
        } else {
            boolean hasMoreThanOneMatcher;
            String[] matchers = FilterTypeUtil.getFilterNames(this.createGroupOnly);
            boolean bl = hasMoreThanOneMatcher = matchers.length > 1;
            if (hasMoreThanOneMatcher) {
                this.createMatcherCombo(composite, font);
                GridData data = new GridData(16384, 0x1000000, false, false);
                this.idCombo.setLayoutData((Object)data);
            }
            this.idComposite = this.createGroup(font, composite, hasMoreThanOneMatcher ? IDEWorkbenchMessages.ResourceFilterPage_details : matchers[0], true, true, 1);
            GridLayout layout = (GridLayout)this.idComposite.getLayout();
            layout.marginBottom = 0;
            layout.marginTop = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            this.idComposite.setLayout((Layout)layout);
        }
        this.argumentComposite = new Composite(this.idComposite, 0);
        this.setupPatternLine();
    }

    private void createMatcherCombo(Composite composite, Font font) {
        this.idCombo = new Combo(composite, 8);
        this.idCombo.setItems(FilterTypeUtil.getFilterNames(this.createGroupOnly));
        GridData data = new GridData(16384, 0x1000000, true, false);
        this.idCombo.setLayoutData((Object)data);
        this.idCombo.setFont(font);
        this.idCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.ID, FilterEditDialog.this.idCombo.getItem(FilterEditDialog.this.idCombo.getSelectionIndex()));
                if (FilterEditDialog.this.filter.hasStringArguments()) {
                    FilterEditDialog.this.filter.setArguments(new String());
                }
                FilterEditDialog.this.setupPatternLine();
                FilterEditDialog.this.currentCustomFilterArgumentUI.selectionChanged();
                FilterEditDialog.this.getShell().layout(true);
                Point size = FilterEditDialog.this.getShell().computeSize(-1, -1);
                Point shellSize = FilterEditDialog.this.getShell().getSize();
                size.x = Math.max(size.x, shellSize.x);
                size.y = Math.max(size.y, shellSize.y);
                FilterEditDialog.this.getShell().setSize(size);
                FilterEditDialog.this.getShell().redraw();
            }
        });
        this.idCombo.select(0);
        this.selectComboItem(this.filter.getId());
        FilterTypeUtil.setValue(this.filter, FilterTypeUtil.ID, this.idCombo.getItem(this.idCombo.getSelectionIndex()));
    }

    ICustomFilterArgumentUI getUI(String descriptorID) {
        ICustomFilterArgumentUI result = (ICustomFilterArgumentUI)this.customfilterArgumentMap.get(descriptorID);
        if (result == null) {
            result = (ICustomFilterArgumentUI)this.customfilterArgumentMap.get(new String());
            return result;
        }
        return result;
    }

    private void setupPatternLine() {
        IFilterMatcherDescriptor descriptor;
        if (this.createGroupOnly) {
            String item = this.idCombo.getItem(this.idCombo.getSelectionIndex());
            descriptor = FilterTypeUtil.getDescriptorByName(item);
        } else {
            descriptor = FilterTypeUtil.getDescriptor(this.filter.getId());
        }
        Font font = this.idComposite.getFont();
        ICustomFilterArgumentUI customFilterArgumentUI = this.getUI(descriptor.getId());
        if (!this.currentCustomFilterArgumentUI.getID().equals(customFilterArgumentUI.getID())) {
            this.currentCustomFilterArgumentUI.dispose();
            this.currentCustomFilterArgumentUI = customFilterArgumentUI;
            this.currentCustomFilterArgumentUI.create(this.argumentComposite, font);
        }
    }

    private void selectComboItem(String filterID) {
        IFilterMatcherDescriptor descriptor = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptor(filterID);
        if (descriptor != null) {
            String[] items = this.idCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(descriptor.getName())) {
                    this.idCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private Composite createGroup(Font font, Composite composite, String text, boolean grabExcessVerticalSpace, boolean group, int columnCounts) {
        Composite modeComposite;
        if (group) {
            Group modeGroup = new Group(composite, 0);
            modeGroup.setText(text);
            modeComposite = modeGroup;
        } else {
            modeComposite = new Composite(composite, 0);
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = this.convertHorizontalDLUsToPixels(7);
        layout.marginLeft = 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = columnCounts;
        modeComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, grabExcessVerticalSpace);
        modeComposite.setLayoutData((Object)data);
        modeComposite.setFont(font);
        return modeComposite;
    }

    private void createTargetArea(Font font, Composite composite) {
        Composite targetComposite = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterTarget, null), false, true, 1);
        String[] targets = FilterTypeUtil.getTargets();
        this.filesButton = new Button(targetComposite, 16);
        this.filesButton.setText(targets[0]);
        GridData data = new GridData(16384, 0x1000000, false, false);
        this.filesButton.setLayoutData((Object)data);
        this.filesButton.setFont(font);
        this.foldersButton = new Button(targetComposite, 16);
        this.foldersButton.setText(targets[1]);
        data = new GridData(16384, 0x1000000, false, false);
        this.foldersButton.setLayoutData((Object)data);
        this.foldersButton.setFont(font);
        this.filesAndFoldersButton = new Button(targetComposite, 16);
        this.filesAndFoldersButton.setText(targets[2]);
        data = new GridData(16384, 0x1000000, false, false);
        this.filesAndFoldersButton.setLayoutData((Object)data);
        this.filesAndFoldersButton.setFont(font);
        this.filesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(0));
            }
        });
        this.foldersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(1));
            }
        });
        this.filesAndFoldersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(2));
            }
        });
        this.filesButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 0);
        this.foldersButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 1);
        this.filesAndFoldersButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 2);
        this.createInheritableArea(font, targetComposite);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.initialize();
        this.update();
        return control;
    }

    public void updateFinishControls() {
        if (this.getButton(0) != null) {
            if (this.currentCustomFilterArgumentUI != null) {
                this.getButton(0).setEnabled(this.currentCustomFilterArgumentUI.validate() == null);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        String title = null;
        title = this.creatingNewFilter ? (this.resource.getType() == 4 ? NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_newFilterDialogTitleProject, (Object)this.resource.getName()) : NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_newFilterDialogTitleFolder, (Object)this.resource.getName())) : IDEWorkbenchMessages.ResourceFilterPage_editFilterDialogTitle;
        newShell.setText(title);
        super.configureShell(newShell);
    }

    private void initialize() {
    }

    protected void update() {
    }

    protected void okPressed() {
        IFilterMatcherDescriptor desc;
        if (this.filter.hasStringArguments() && (desc = this.resource.getWorkspace().getFilterMatcherDescriptor(this.filter.getId())) != null) {
            try {
                this.currentCustomFilterArgumentUI.validate();
                AbstractFileInfoMatcher matcher = ((FilterDescriptor)desc).createFilter();
                matcher.initialize(this.resource.getProject(), this.filter.getArguments());
            }
            catch (CoreException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    ErrorDialog.openError((Shell)window.getShell(), (String)IDEWorkbenchMessages.ResourceFilterPage_editFilterDialogTitle, (String)e.getMessage(), (IStatus)e.getStatus());
                }
                return;
            }
        }
        super.okPressed();
    }

    public int getVerticalDLUsToPixel(int flag) {
        return this.convertVerticalDLUsToPixels(flag);
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getHorizontalDLUsToPixel(int flag) {
        return this.convertHorizontalDLUsToPixels(flag);
    }
}

