/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui.screenshots;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.commons.ui.screenshots.Messages;
import org.eclipse.mylyn.internal.commons.ui.screenshots.ScreenshotImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class SelectToolAction
extends Action
implements IMenuCreator {
    public static final int CAPTURE_DROP_DOWN_MENU = 1;
    public static final int ZOOM_DROP_DOWN_MENU = 2;
    public static final int DRAWLINE_TOOLBAR = 3;
    public static final int DRAWARROW_TOOLBAR = 4;
    public static final int DRAWBOX_TOOLBAR = 5;
    public static final int DRAWTEXT_TOOLBAR = 6;
    public static final int LINETYPE_TOOLBAR = 7;
    public static final int LINEBOLD_TOOLBAR = 8;
    public static final int COLOR_TOOLBAR = 9;
    private ToolActionItem[] items;
    private int selectedItemID;
    private ToolComposite toolButton;
    private Menu dropDownMenu;
    private int intgerCustom;
    private String stringCustom;
    private boolean showMenuAlways;
    public static final int ZOOM_FIT = 0;
    public static final int DRAW_FREE = 0;
    public static final int DRAW_LINE = 1;
    public static final int DRAW_ARROW1 = 2;
    public static final int DRAW_ARROW2 = 3;
    public static final int DRAW_BOX = 10;
    public static final int DRAW_RBOX = 11;
    public static final int DRAW_FILL_BOX = 12;
    public static final int DRAW_FILL_RBOX = 13;
    public static final int DRAW_OVAL = 20;
    public static final int DRAW_FILL_OVAL = 21;
    public static final int DRAW_TEXT = 30;
    public static final int CAPTURE_DESKTOP = 0;
    public static final int CAPTURE_CLIPBOARD = 1;
    public static final int CAPTURE_FILE = 2;
    public static final int CAPTURE_RECTANGLE = 3;
    public static final int CAPTURE_DESKTOP_DELAYED = 4;
    private final Composite parent;
    private boolean showSelection;

    public SelectToolAction(Composite parent, int tool) {
        this(parent, "", tool);
    }

    public SelectToolAction(String label, int tool) {
        this(null, label, tool);
    }

    public SelectToolAction(Composite parent, String label, int tool) {
        super(label, 4);
        this.setMenuCreator(this);
        this.showMenuAlways = true;
        this.parent = parent;
        this.setToolAction(tool);
    }

    private void setToolAction(int tool) {
        if (tool == 1) {
            this.selectedItemID = 0;
            this.initMenu(tool, new ToolActionItem[]{new ToolActionItem(0, Messages.SelectToolAction_Desktop, ScreenshotImages.MONITOR_OBJ), new ToolActionItem(4, Messages.SelectToolAction_Desktop_Delayed, ScreenshotImages.MONITOR__DELAY_OBJ), new ToolActionItem(1, Messages.SelectToolAction_Clipboard, ScreenshotImages.CLIPBOARD_OBJ), new ToolActionItem(2, Messages.SelectToolAction_File, ScreenshotImages.FILE_OBJ), new ToolActionItem(3, Messages.SelectToolAction_Selected_Rectangle, ScreenshotImages.SEL_RECT)});
            return;
        }
        if (tool == 2) {
            this.selectedItemID = 0;
            this.initMenu(tool, new ToolActionItem[]{new ToolActionItem(0, Messages.SelectToolAction_Fit, null), new ToolActionItem(50, Messages.SelectToolAction_ZoomHalf, null), new ToolActionItem(100, Messages.SelectToolAction_Zoom1X, null), new ToolActionItem(200, Messages.SelectToolAction_Zoom2X, null), new ToolActionItem(400, Messages.SelectToolAction_Zoom4X, null), new ToolActionItem(800, Messages.SelectToolAction_Zoom8X, null)});
            return;
        }
        if (tool == 7) {
            this.selectedItemID = 1;
            this.initBar(tool, new ToolActionItem[]{new ToolActionItem(1, Messages.SelectToolAction_Solid_Line, ScreenshotImages.LINE_SOLD), new ToolActionItem(3, Messages.SelectToolAction_Dotted_Line, ScreenshotImages.LINE_DOT), new ToolActionItem(2, Messages.SelectToolAction_Dashed_Line, ScreenshotImages.LINE_DASH), new ToolActionItem(4, Messages.SelectToolAction_Dashed_Line_1_dot, ScreenshotImages.LINE_DASH1D), new ToolActionItem(5, Messages.SelectToolAction_Dashed_Line_2_dots, ScreenshotImages.LINE_DASH2D)});
            return;
        }
        if (tool == 3) {
            this.showSelection = true;
            this.selectedItemID = 0;
            this.initBar(tool, new ToolActionItem[]{new ToolActionItem(0, Messages.SelectToolAction_Free, ScreenshotImages.EDIT_FREE), new ToolActionItem(1, Messages.SelectToolAction_Line, ScreenshotImages.EDIT_LINE)});
            return;
        }
        if (tool == 4) {
            this.showSelection = true;
            this.selectedItemID = 2;
            this.initBar(tool, new ToolActionItem[]{new ToolActionItem(2, Messages.SelectToolAction_Single_Side_Arrow, ScreenshotImages.EDIT_ARROW1), new ToolActionItem(3, Messages.SelectToolAction_Both_Side_Arrow, ScreenshotImages.EDIT_ARROW2)});
            this.selectedItemID = -1;
            return;
        }
        if (tool == 5) {
            this.showSelection = true;
            this.selectedItemID = 11;
            this.initBar(tool, new ToolActionItem[]{new ToolActionItem(10, Messages.SelectToolAction_Rectangle, ScreenshotImages.EDIT_BOX), new ToolActionItem(11, Messages.SelectToolAction_Round_Rectangle, ScreenshotImages.EDIT_RBOX), new ToolActionItem(20, Messages.SelectToolAction_Oval, ScreenshotImages.EDIT_OVAL), new ToolActionItem(12, Messages.SelectToolAction_Fill_Rectangle, ScreenshotImages.EDIT_FILL_BOX), new ToolActionItem(13, Messages.SelectToolAction_Fill_Round_Rectangle, ScreenshotImages.EDIT_FILL_RBOX), new ToolActionItem(21, Messages.SelectToolAction_Fill_Oval, ScreenshotImages.EDIT_FILL_OVAL)});
            this.selectedItemID = -1;
            return;
        }
        if (tool == 6) {
            this.showSelection = true;
            this.selectedItemID = 30;
            FontData fontData = JFaceResources.getFont((String)"org.eclipse.jface.headerfont").getFontData()[0];
            this.stringCustom = fontData.toString();
            this.selectedItemID = this.intgerCustom = SelectToolAction.rgb2int(255, 0, 0);
            this.initFont(tool);
            this.selectedItemID = -1;
            return;
        }
        if (tool == 8) {
            this.selectedItemID = 4;
            this.initBar(tool, new ToolActionItem[]{new ToolActionItem(1, Messages.SelectToolAction_1dot, ScreenshotImages.LINE_BOLD1), new ToolActionItem(2, Messages.SelectToolAction_2dots, ScreenshotImages.LINE_BOLD2), new ToolActionItem(4, Messages.SelectToolAction_4dots, ScreenshotImages.LINE_BOLD4), new ToolActionItem(8, Messages.SelectToolAction_8dots, ScreenshotImages.LINE_BOLD8)});
            return;
        }
        if (tool == 9) {
            this.selectedItemID = this.intgerCustom = SelectToolAction.rgb2int(255, 85, 85);
            this.initColor(tool);
            return;
        }
    }

    private void initBar(int tool, ToolActionItem[] items) {
        this.items = items;
        this.setId(String.valueOf(tool));
        this.toolButton = new ToolComposite(this.parent, 64){

            public void clickBody() {
                SelectToolAction.this.selectAndRun(this.getToolTipText(), null);
            }

            public void clickMenu(int x, int y) {
                SelectToolAction.this.dropDownMenu = new Menu((Decorations)SelectToolAction.this.parent.getShell(), 8);
                SelectToolAction.this.addActionsToMenu();
                Point p = SelectToolAction.this.parent.toDisplay(x, y);
                SelectToolAction.this.dropDownMenu.setLocation(p.x, p.y);
                SelectToolAction.this.dropDownMenu.setVisible(true);
                SelectToolAction.this.dropDownMenu = null;
            }

            public boolean isSelect() {
                return SelectToolAction.this.selectedItemID >= 0;
            }
        };
        if (items != null) {
            ToolActionItem[] toolActionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ToolActionItem actionItem = toolActionItemArray[n2];
                if (actionItem.id == this.selectedItemID) {
                    this.toolButton.setImage(actionItem.image.createImage());
                    this.toolButton.setToolTipText(actionItem.label);
                }
                ++n2;
            }
        }
    }

    private void initFont(int tool) {
        this.items = null;
        this.setId(String.valueOf(tool));
        this.toolButton = new ToolComposite(this.parent, 64){

            public void clickBody() {
                SelectToolAction.this.selectedItemID = 30;
                if (SelectToolAction.this.toolButton != null) {
                    FontData fontData = new FontData(SelectToolAction.this.stringCustom);
                    SelectToolAction.this.toolButton.setImage(SelectToolAction.this.createFontImage(fontData, SelectToolAction.int2rgb(SelectToolAction.this.intgerCustom), true));
                    SelectToolAction.this.toolButton.redraw();
                }
                SelectToolAction.this.run();
            }

            public void clickMenu(int x, int y) {
                if (Platform.getWS().equalsIgnoreCase("win32") || Platform.getWS().equalsIgnoreCase("wpf")) {
                    this.invokeFontDialog();
                } else {
                    Menu rightClickMenu = new Menu((Decorations)SelectToolAction.this.parent.getShell(), 8);
                    MenuItem menuItem = new MenuItem(rightClickMenu, 8);
                    menuItem.setText(Messages.SelectToolAction_Font_);
                    menuItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            this.invokeFontDialog();
                        }
                    });
                    menuItem = new MenuItem(rightClickMenu, 8);
                    menuItem.setText(Messages.SelectToolAction_Color_);
                    menuItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            this.invokeColorDialog();
                        }
                    });
                    Point p = SelectToolAction.this.parent.toDisplay(x, y);
                    rightClickMenu.setLocation(p.x, p.y);
                    rightClickMenu.setVisible(true);
                }
            }

            public boolean isSelect() {
                return SelectToolAction.this.selectedItemID >= 0;
            }

            public void invokeFontDialog() {
                FontData fontData = new FontData(SelectToolAction.this.stringCustom);
                FontDialog fontWindow = new FontDialog(SelectToolAction.this.parent.getShell());
                fontWindow.setFontList(new FontData[]{fontData});
                fontWindow.setRGB(SelectToolAction.int2rgb(SelectToolAction.this.intgerCustom));
                fontData = fontWindow.open();
                if (fontData != null) {
                    SelectToolAction.this.intgerCustom = SelectToolAction.rgb2int(fontWindow.getRGB());
                    SelectToolAction.this.stringCustom = fontData.toString();
                    SelectToolAction.this.toolButton.setToolTipText(SelectToolAction.this.font2string(fontData));
                    this.clickBody();
                }
            }

            public void invokeColorDialog() {
                ColorDialog colorWindow = new ColorDialog(SelectToolAction.this.parent.getShell());
                colorWindow.setRGB(SelectToolAction.int2rgb(SelectToolAction.this.intgerCustom));
                RGB rgb = colorWindow.open();
                if (rgb != null) {
                    SelectToolAction.this.intgerCustom = SelectToolAction.rgb2int(rgb);
                    this.clickBody();
                }
            }
        };
        FontData fontData = new FontData(this.stringCustom);
        this.toolButton.setToolTipText(this.font2string(fontData));
        this.toolButton.setImage(this.createFontImage(fontData, SelectToolAction.int2rgb(this.intgerCustom), false));
    }

    private void initColor(int tool) {
        this.items = null;
        this.setId(String.valueOf(tool));
        this.toolButton = new ToolComposite(this.parent, 0){

            public void clickMenu(int x, int y) {
                ColorDialog colorWindow = new ColorDialog(SelectToolAction.this.parent.getShell());
                colorWindow.setRGB(SelectToolAction.int2rgb(SelectToolAction.this.intgerCustom));
                RGB rgb = colorWindow.open();
                if (rgb != null) {
                    SelectToolAction.this.intgerCustom = SelectToolAction.rgb2int(rgb);
                    SelectToolAction.this.selectedItemID = SelectToolAction.this.intgerCustom;
                    SelectToolAction.this.toolButton.setImage(SelectToolAction.this.createColorImage(SelectToolAction.int2rgb(SelectToolAction.this.intgerCustom)));
                    SelectToolAction.this.toolButton.redraw();
                }
            }
        };
        this.toolButton.setToolTipText("");
        this.toolButton.setImage(this.createColorImage(SelectToolAction.int2rgb(this.intgerCustom)));
    }

    private Image createColorImage(RGB rgb) {
        Display display = this.parent.getDisplay();
        Color BACKGROUND = display.getSystemColor(22);
        Color DARK_GRAY = display.getSystemColor(16);
        int x = 16;
        int y = 16;
        Image image = new Image((Device)display, x, y);
        GC gc = new GC((Drawable)image);
        gc.setForeground(DARK_GRAY);
        gc.setBackground(BACKGROUND);
        gc.fillRectangle(0, 0, x, y);
        gc.setBackground(new Color((Device)display, rgb));
        gc.fillRectangle(1, 2, x - 2, y - 4);
        gc.drawRectangle(1, 2, x - 3, y - 5);
        gc.dispose();
        return image;
    }

    private Image createFontImage(FontData fontData, RGB rgb, boolean select) {
        Display display = this.parent.getDisplay();
        Color ButtonFace = display.getSystemColor(select ? 20 : 22);
        int x = 16;
        int y = 16;
        Image image = new Image((Device)display, x, y);
        GC gc = new GC((Drawable)image);
        gc.setBackground(ButtonFace);
        gc.fillRectangle(0, 0, x, y);
        String label = "A";
        gc.setFont(new Font((Device)display, new FontData(fontData.getName(), 11, fontData.getStyle())));
        gc.setForeground(new Color((Device)display, rgb));
        Point sz = gc.textExtent(label);
        gc.drawText(label, (x - sz.x) / 2, (y - sz.y) / 2 + 1, true);
        gc.dispose();
        return image;
    }

    private void initMenu(int tool, ToolActionItem[] items) {
        this.items = items;
        this.setId(String.valueOf(tool));
        if (items != null) {
            this.setImageDescriptor(items[0].image);
            this.setToolTipText(items[0].label);
            this.selectedItemID = items[0].id;
        }
    }

    public boolean isShowMenuAlways() {
        return this.showMenuAlways;
    }

    public void setShowMenuAlways(boolean showMenuAlways) {
        this.showMenuAlways = showMenuAlways;
    }

    public void runWithEvent(Event event) {
        Widget item;
        ToolItem ti;
        Menu m;
        IMenuCreator mc;
        if (this.showMenuAlways && (mc = this.getMenuCreator()) != null && (m = mc.getMenu((Control)(ti = (ToolItem)(item = event.widget)).getParent())) != null) {
            Rectangle itemBounds = ti.getBounds();
            Point point = ti.getParent().toDisplay(itemBounds.x, itemBounds.y + itemBounds.height);
            m.setLocation(point.x, point.y);
            m.setVisible(true);
            return;
        }
        super.runWithEvent(event);
    }

    public int getSelect() {
        return this.selectedItemID;
    }

    public boolean setSelect(int select) {
        if (this.items != null) {
            ToolActionItem[] toolActionItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                ToolActionItem actionItem = toolActionItemArray[n2];
                if (select == actionItem.id) {
                    this.selectItem(actionItem.label, null);
                    return true;
                }
                ++n2;
            }
        } else if (this.getId().equals("6")) {
            this.toolButton.clickBody();
            return true;
        }
        return false;
    }

    public void setUnselect() {
        this.selectedItemID = -1;
        if (this.toolButton != null) {
            if (this.getId().equals("6")) {
                FontData fontData = new FontData(this.stringCustom);
                this.toolButton.setImage(this.createFontImage(fontData, SelectToolAction.int2rgb(this.intgerCustom), false));
            }
            this.toolButton.redraw();
        }
    }

    public int getIntgerCustom() {
        return this.intgerCustom;
    }

    public String getStringCustom() {
        return this.stringCustom;
    }

    protected void selectAndRun(String label, ImageDescriptor image) {
        if (this.selectItem(label, image)) {
            if (this.getId().equals("1")) {
                if (this.selectedItemID == 2) {
                    FileDialog dialog = new FileDialog(this.parent.getShell());
                    dialog.setFileName(this.stringCustom);
                    dialog.setFilterExtensions(new String[]{"*.bmp;*.jpg;*.png", "*.*"});
                    String result = dialog.open();
                    if (result != null && result.length() > 0) {
                        this.stringCustom = result;
                        this.run();
                    }
                } else {
                    this.run();
                }
                this.selectedItemID = 0;
            } else {
                this.run();
            }
        }
    }

    protected boolean selectItem(String label, ImageDescriptor image) {
        ToolActionItem[] toolActionItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolActionItem actionItem = toolActionItemArray[n2];
            if (actionItem.label.equals(label)) {
                this.selectedItemID = actionItem.id;
                if (!this.getId().equals("1")) {
                    this.setToolTipText(label);
                    if (image != null) {
                        this.setImageDescriptor(image);
                    }
                    if (this.toolButton != null) {
                        this.toolButton.setToolTipText(label);
                        if (image != null) {
                            this.toolButton.setImage(image.createImage());
                        }
                        this.toolButton.redraw();
                    }
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addActionsToMenu() {
        ToolActionItem[] toolActionItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolActionItem actionItem = toolActionItemArray[n2];
            Action action = new Action(){

                public void run() {
                    SelectToolAction.this.selectAndRun(this.getText(), this.getImageDescriptor());
                }
            };
            action.setText(actionItem.label);
            if (actionItem.image != null) {
                action.setImageDescriptor(actionItem.image);
            }
            this.updateAction(action, actionItem.id);
            ActionContributionItem contributionItem = new ActionContributionItem((IAction)action);
            contributionItem.fill(this.dropDownMenu, -1);
            ++n2;
        }
    }

    private void updateAction(Action action, int id) {
        action.setChecked(id == this.selectedItemID);
        if (this.getId().equals("1")) {
            if (id == 1) {
                action.setEnabled(this.existImageOnClipboard());
            } else if (id == 3) {
                action.setEnabled(this.isEnableRectangle());
            }
        }
    }

    protected boolean isEnableRectangle() {
        return false;
    }

    public void dispose() {
        if (this.toolButton != null) {
            this.toolButton.dispose();
            this.toolButton = null;
        }
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public boolean getVisible() {
        if (this.toolButton != null) {
            return this.toolButton.getVisible();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (this.toolButton != null) {
            this.toolButton.setVisible(visible);
            this.toolButton.redraw();
        }
    }

    public boolean getEnabled() {
        if (this.toolButton != null) {
            return this.toolButton.getEnabled();
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.toolButton != null) {
            this.toolButton.setEnabled(enabled);
            this.toolButton.redraw();
        }
    }

    public Image getFileImage() {
        try {
            Image image = new Image((Device)this.parent.getShell().getDisplay(), this.stringCustom);
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Transfer getImageTransfer() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.dnd.ImageTransfer");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            if (method != null) {
                return (Transfer)method.invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {}
        return null;
    }

    public Image getClipboardImage() {
        Object data;
        Clipboard clipboard = new Clipboard(this.parent.getShell().getDisplay());
        Transfer imageTransfer = this.getImageTransfer();
        if (imageTransfer != null && (data = clipboard.getContents(imageTransfer)) instanceof ImageData) {
            Image image = new Image((Device)this.parent.getShell().getDisplay(), (ImageData)data);
            return image;
        }
        return null;
    }

    private boolean existImageOnClipboard() {
        Object data;
        Clipboard clipboard = new Clipboard(this.parent.getShell().getDisplay());
        Transfer imageTransfer = this.getImageTransfer();
        return imageTransfer != null && (data = clipboard.getContents(imageTransfer)) instanceof ImageData;
    }

    public static int rgb2int(RGB rgb) {
        return SelectToolAction.rgb2int(rgb.red, rgb.green, rgb.blue);
    }

    public static int rgb2int(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    public static RGB int2rgb(int rgb) {
        return new RGB(rgb >> 16, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    private String font2string(FontData fontData) {
        String info = NLS.bind((String)Messages.SelectToolAction_Font_Name_Size, (Object[])new Object[]{fontData.getName(), String.valueOf(fontData.getHeight())});
        int style = fontData.getStyle();
        if ((style & 1) != 0) {
            info = String.valueOf(info) + Messages.SelectToolAction_Font_Bold;
        }
        if ((style & 2) != 0) {
            info = String.valueOf(info) + Messages.SelectToolAction_Font_Italic;
        }
        return info;
    }

    private class ToolActionItem {
        int id;
        String label;
        ImageDescriptor image;

        ToolActionItem(int id, String label, ImageDescriptor image) {
            this.id = id;
            this.label = label;
            this.image = image;
        }
    }

    private class ToolComposite
    extends Composite {
        private Image image;
        private final boolean bMenu;
        private boolean bMouse;
        private static final int S = 1;
        private static final int B = 2;
        private static final int G = 3;
        private static final int M = 4;
        private final Point iconSize;
        private final Point maxSize;

        public ToolComposite(Composite parent, int style) {
            super(parent, style);
            this.iconSize = new Point(22, 22);
            this.maxSize = new Point(this.iconSize.x + 3 + 4 + 3, this.iconSize.y);
            this.bMenu = (style & 0x40) != 0;
            this.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Color background = e.gc.getBackground();
                    Color foreground = e.gc.getForeground();
                    Display display = e.widget.getDisplay();
                    Color NORMAL_SHADOW = display.getSystemColor(18);
                    boolean enabled = ToolComposite.this.getEnabled();
                    if (ToolComposite.this.bMouse && enabled) {
                        e.gc.setForeground(NORMAL_SHADOW);
                        if (ToolComposite.this.bMenu) {
                            e.gc.drawRectangle(0, 0, ((ToolComposite)ToolComposite.this).maxSize.x - 1, ((ToolComposite)ToolComposite.this).maxSize.y - 1);
                            e.gc.drawLine(((ToolComposite)ToolComposite.this).iconSize.x, 0, ((ToolComposite)ToolComposite.this).iconSize.x, ((ToolComposite)ToolComposite.this).maxSize.y);
                        } else {
                            e.gc.drawRectangle(0, 0, ((ToolComposite)ToolComposite.this).iconSize.x - 1, ((ToolComposite)ToolComposite.this).iconSize.y - 1);
                        }
                    }
                    if (SelectToolAction.this.showSelection && ToolComposite.this.isSelect() && enabled) {
                        Color HIGHLIGHT_SHADOW = display.getSystemColor(20);
                        Color LIGHT_SHADOW = display.getSystemColor(19);
                        Color SELECTION = display.getSystemColor(26);
                        e.gc.setBackground(HIGHLIGHT_SHADOW);
                        e.gc.fillRectangle(0, 0, ((ToolComposite)ToolComposite.this).iconSize.x, ((ToolComposite)ToolComposite.this).iconSize.y);
                        e.gc.setForeground(NORMAL_SHADOW);
                        e.gc.drawLine(1, 1, ((ToolComposite)ToolComposite.this).iconSize.x - 1 - 1, 1);
                        e.gc.drawLine(2, 2, ((ToolComposite)ToolComposite.this).iconSize.x - 1 - 2, 2);
                        e.gc.drawLine(1, 1, 1, ((ToolComposite)ToolComposite.this).iconSize.y - 1 - 1);
                        e.gc.drawLine(2, 2, 2, ((ToolComposite)ToolComposite.this).iconSize.y - 1 - 2);
                        e.gc.setForeground(HIGHLIGHT_SHADOW);
                        e.gc.drawLine(((ToolComposite)ToolComposite.this).iconSize.x - 1 - 1, 2, ((ToolComposite)ToolComposite.this).iconSize.x - 1 - 1, ((ToolComposite)ToolComposite.this).iconSize.y - 1 - 1);
                        e.gc.drawLine(1, ((ToolComposite)ToolComposite.this).iconSize.y - 1 - 1, ((ToolComposite)ToolComposite.this).iconSize.x - 1 - 1, ((ToolComposite)ToolComposite.this).iconSize.y - 1 - 1);
                        e.gc.setForeground(LIGHT_SHADOW);
                        e.gc.drawLine(((ToolComposite)ToolComposite.this).iconSize.x - 1 - 2, 3, ((ToolComposite)ToolComposite.this).iconSize.x - 1 - 2, ((ToolComposite)ToolComposite.this).iconSize.y - 1 - 2);
                        e.gc.drawLine(2, ((ToolComposite)ToolComposite.this).iconSize.x - 1 - 2, ((ToolComposite)ToolComposite.this).iconSize.x - 1 - 2, ((ToolComposite)ToolComposite.this).iconSize.y - 1 - 2);
                        e.gc.setForeground(SELECTION);
                        e.gc.drawRectangle(0, 0, ((ToolComposite)ToolComposite.this).iconSize.x - 1, ((ToolComposite)ToolComposite.this).iconSize.y - 1);
                    }
                    if (ToolComposite.this.getEnabled()) {
                        e.gc.drawImage(ToolComposite.this.image, 3, 3);
                    } else {
                        Image disabled = new Image((Device)display, ToolComposite.this.image, 1);
                        e.gc.drawImage(disabled, 3, 3);
                    }
                    if (ToolComposite.this.bMenu) {
                        Color FOREGROUND;
                        if (Platform.getWS().equalsIgnoreCase("win32") || Platform.getWS().equalsIgnoreCase("wpf")) {
                            FOREGROUND = display.getSystemColor(ToolComposite.this.getEnabled() ? 21 : 17);
                            e.gc.setForeground(FOREGROUND);
                            int x = ((ToolComposite)ToolComposite.this).iconSize.x + 3;
                            int y = 7;
                            int h = 6;
                            while (h >= 0) {
                                e.gc.drawLine(x, y, x, y + h);
                                ++x;
                                ++y;
                                h -= 2;
                            }
                        } else {
                            FOREGROUND = display.getSystemColor(ToolComposite.this.getEnabled() ? 17 : 18);
                            e.gc.setForeground(FOREGROUND);
                            int x = ((ToolComposite)ToolComposite.this).iconSize.x + 3;
                            int y = 7;
                            int h = 4;
                            e.gc.drawLine(x, y, x + h / 2 + 1, y + h / 2 + 1);
                            e.gc.drawLine(x, y + 1, x + h / 2, y + h / 2 + 1);
                            e.gc.drawLine(x, y + h + 1, x + h / 2, y + h / 2 + 1);
                            e.gc.drawLine(x, y + h + 2, x + h / 2, y + h / 2 + 2);
                        }
                    }
                    e.gc.setBackground(background);
                    e.gc.setForeground(foreground);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.x < ((ToolComposite)ToolComposite.this).iconSize.x && e.y < ((ToolComposite)ToolComposite.this).iconSize.y) {
                        if (SelectToolAction.this.showSelection) {
                            ToolComposite.this.clickBody();
                            return;
                        }
                        this.invokeMenu((Composite)e.widget);
                    } else {
                        this.invokeMenu((Composite)e.widget);
                    }
                }

                private void invokeMenu(Composite widget) {
                    Rectangle b = widget.getBounds();
                    Point p = widget.getLocation();
                    p.x += b.width + 3;
                    ToolComposite.this.bMouse = false;
                    ToolComposite.this.redraw();
                    ToolComposite.this.clickMenu(p.x, p.y);
                }
            });
            this.addListener(6, new Listener(){

                public void handleEvent(Event event) {
                    if (ToolComposite.this.getEnabled()) {
                        ToolComposite.this.bMouse = true;
                        ToolComposite.this.redraw();
                    }
                }
            });
            this.addListener(5, new Listener(){

                public void handleEvent(Event event) {
                    if (ToolComposite.this.getEnabled()) {
                        ToolComposite.this.bMouse = true;
                        ToolComposite.this.redraw();
                    }
                }
            });
            this.addListener(7, new Listener(){

                public void handleEvent(Event event) {
                    if (ToolComposite.this.getEnabled()) {
                        ToolComposite.this.bMouse = false;
                        ToolComposite.this.redraw();
                    }
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (!this.getVisible()) {
                return new Point(0, 0);
            }
            return this.maxSize;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public void clickBody() {
        }

        public void clickMenu(int x, int y) {
        }

        public boolean isSelect() {
            return false;
        }
    }
}

