/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording.filtering;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.epp.usagedata.internal.recording.filtering.FilterChangeListener;
import org.eclipse.epp.usagedata.internal.recording.filtering.UsageDataEventFilter;
import org.eclipse.jface.util.IPropertyChangeListener;

public abstract class AbstractUsageDataEventFilter
implements UsageDataEventFilter {
    ListenerList changeListeners = new ListenerList();
    IPropertyChangeListener propertyChangeListener;

    public void addFilterChangeListener(FilterChangeListener filterChangeListener) {
        this.changeListeners.add((Object)filterChangeListener);
    }

    public void removeFilterChangeListener(FilterChangeListener filterChangeListener) {
        this.changeListeners.remove((Object)filterChangeListener);
    }

    protected void fireFilterChangedEvent() {
        Object[] objectArray = this.changeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((FilterChangeListener)listener).filterChanged();
            ++n2;
        }
    }

    protected boolean matches(String pattern, String bundleId) {
        return bundleId.matches(this.asRegex(pattern));
    }

    String asRegex(String filter) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < filter.length()) {
            char next = filter.charAt(index);
            if (next == '*') {
                builder.append(".*");
            } else if (next == '.') {
                builder.append("\\.");
            } else {
                builder.append(next);
            }
            ++index;
        }
        return builder.toString();
    }
}

