/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.webxml;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.common.webxml.internal.AbstractWebXmlUpdater;
import org.eclipse.jst.jsf.common.webxml.internal.WebXmlUpdaterForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.WebXmlUpdaterForJavaEE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXmlUpdater {
    private final IProject project;
    private final IProgressMonitor monitor;
    private final AbstractWebXmlUpdater updater;
    private final IModelProvider provider;

    public WebXmlUpdater(IProject project, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        this.provider = ModelProviderManager.getModelProvider((IProject)project);
        this.updater = this.initUpdater();
    }

    public WebApp getWebAppForJavaEE() {
        return (WebApp)this.updater.getWebApp();
    }

    public org.eclipse.jst.j2ee.webapplication.WebApp getWebAppForJ2EE() {
        return (org.eclipse.jst.j2ee.webapplication.WebApp)this.updater.getWebApp();
    }

    public IModelProvider getProvider() {
        return this.provider;
    }

    public boolean isJavaEEWebapp() {
        return this.updater instanceof WebXmlUpdaterForJavaEE;
    }

    public boolean isJ2EEWebapp() {
        return this.updater instanceof WebXmlUpdaterForJ2EE;
    }

    public void addServlet(String servletName, String servletClass, String loadOnStartup) {
        this.updater.addServlet(servletName, servletClass, loadOnStartup);
    }

    public void removeServlet(String servletClassName) {
        this.updater.removeServlet(servletClassName);
    }

    public void addServletMapping(String servletName, String servletClass, String urlPattern) {
        this.updater.addServletMapping(servletName, servletClass, urlPattern);
    }

    public void addFilter(String filterName, String filterClass) {
        this.updater.addFilter(filterName, filterClass);
    }

    public void removeFilter(String filterName) {
        this.updater.removeFilter(filterName);
    }

    public void addFilterMapping(String filterName, String filterClass, String servletName) {
        this.updater.addFilterMapping(filterName, filterClass, servletName);
    }

    public String getContextParamValue(String paramName) {
        return this.updater.getContextParamValue(paramName);
    }

    public List<String> getContextParamValuesAsList(String paramName, String valuesDelimiterRegex) {
        return this.updater.getContextParamValuesAsList(paramName, valuesDelimiterRegex);
    }

    public void setContextParamValue(String paramName, String paramValue) {
        this.updater.setContextParamValue(paramName, paramValue);
    }

    public void addContextParam(String paramName, String paramValue, String description) {
        this.updater.addContextParam(paramName, paramValue, description);
    }

    public void addListener(String listenerClass) {
        this.updater.addListener(listenerClass);
    }

    private AbstractWebXmlUpdater initUpdater() {
        Object webAppObj = ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
        if (webAppObj != null) {
            if (webAppObj instanceof WebApp) {
                return new WebXmlUpdaterForJavaEE(webAppObj, this.project, this.getProvider(), this.monitor);
            }
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                return new WebXmlUpdaterForJ2EE(webAppObj, this.project, this.getProvider(), this.monitor);
            }
        }
        throw new IllegalArgumentException("Unable to resolve WebApp object for updating web.xml");
    }
}

