/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import org.eclipse.datatools.sqltools.sql.parser.Token;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeclareKeyword;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

public class PasteAction
extends SelectionDispatchAction {
    private final Clipboard _fClipboard;

    public PasteAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        this.setText(Messages.PasteAction_label);
        this.setToolTipText(Messages.PasteAction_tooltip);
        this._fClipboard = clipboard;
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.PASTE_ACTION);
        this.update(this.getSelection());
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof Node)) {
            return false;
        }
        TransferData[] availableDataTypes = this._fClipboard.getAvailableTypes();
        int i = 0;
        while (i < availableDataTypes.length) {
            if (TextTransfer.getInstance().isSupportedType(availableDataTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() > 1 || selection.size() <= 0) {
            return;
        }
        StringBuffer text = new StringBuffer((String)PasteAction.getContents(this._fClipboard, (Transfer)TextTransfer.getInstance(), this.getShell()));
        if (selection.getFirstElement() instanceof Node) {
            Node node = (Node)selection.getFirstElement();
            if (node instanceof IASTSQLParam) {
                text = this.pasteText(node, text);
            } else {
                text.insert(0, System.getProperty("line.separator"));
            }
            int offset = node.getEndOffset();
            if (node.getLastToken().next.image.equals(";")) {
                offset = node.getNextTokenOffset();
                text.append(";");
            }
            IDocument doc = node.getDocument();
            try {
                doc.replace(offset, 0, text.toString());
            }
            catch (BadLocationException e) {
                SQLEditorPlugin.getDefault().log(Messages.PasteAction_1, e);
            }
        }
    }

    private StringBuffer pasteText(Node node, StringBuffer sqlText) {
        StringBuffer text = sqlText;
        Token nextToken = node.getLastToken().next;
        if (node.getPreviousNode() instanceof IASTDeclareKeyword && !nextToken.image.equals(",")) {
            text.insert(0, "DECLARE ");
            text.insert(0, System.getProperty("line.separator"));
            if (nextToken.image.equals(";")) {
                text.append(";");
            }
        } else {
            text.insert(0, ", ");
        }
        return text;
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] result = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = clipboard.getContents(transfer);
            }
        });
        return result[0];
    }
}

