/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAttribute;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJavaPersistentAttribute
extends AbstractJavaContextNode
implements JaxbPersistentAttribute {
    protected JaxbAttributeMapping mapping;
    protected String defaultMappingKey;
    private static final String COLLECTION_CLASS_NAME = Collection.class.getName();

    protected GenericJavaPersistentAttribute(JaxbPersistentClass parent) {
        super(parent);
    }

    @Override
    public JaxbPersistentClass getParent() {
        return (JaxbPersistentClass)super.getParent();
    }

    @Override
    public boolean isInherited() {
        return this.getParent().isInherited(this);
    }

    @Override
    public String getInheritedJavaResourceAttributeOwningTypeName() {
        return this.getParent().getJavaResourceAttributeOwningTypeName(this);
    }

    protected void initializeMapping() {
        this.mapping = this.buildMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncMapping();
    }

    @Override
    public void update() {
        super.update();
        this.updateMapping();
    }

    @Override
    public String getName() {
        return this.getJavaResourceAttribute().getName();
    }

    @Override
    public JaxbAttributeMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(JaxbAttributeMapping mapping) {
        JaxbAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public JaxbAttributeMapping setMappingKey(String key) {
        if (this.mapping.isDefault()) {
            if (key != null) {
                this.setMappingKey_(key);
            }
        } else if (!this.valuesAreEqual(key, this.mapping.getKey())) {
            this.setMappingKey_(key);
        }
        return this.mapping;
    }

    protected void setMappingKey_(String key) {
        JavaAttributeMappingDefinition definition = this.getSpecifiedMappingDefinition(key);
        if (definition == null) {
            definition = this.getDefaultMappingDefinition();
            Iterable<String> supportingAnnotationNames = definition != null ? definition.getSupportingAnnotationNames() : EmptyIterable.instance();
            this.setMappingAnnotation(null, supportingAnnotationNames);
        } else {
            this.setMappingAnnotation(definition);
        }
        this.setMapping(this.buildMapping(definition));
    }

    protected void setMappingAnnotation(JavaAttributeMappingDefinition definition) {
        this.setMappingAnnotation(definition.getAnnotationName(), definition.getSupportingAnnotationNames());
    }

    protected void setMappingAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        this.getJavaResourceAttribute().setPrimaryAnnotation(primaryAnnotationName, supportingAnnotationNames);
    }

    protected JaxbAttributeMapping buildMapping(JavaAttributeMappingDefinition definition) {
        return definition == null ? this.buildNullMapping() : this.buildMapping_(definition);
    }

    protected JaxbAttributeMapping buildNullMapping() {
        return this.getFactory().buildJavaNullAttributeMapping(this);
    }

    protected JaxbAttributeMapping buildMapping_(JavaAttributeMappingDefinition definition) {
        if (this.mapping != null && this.mapping.isDefault() && Tools.valuesAreEqual((Object)this.mapping.getKey(), (Object)definition.getKey())) {
            this.mapping.updateDefault();
            return this.mapping;
        }
        return definition.buildMapping(this, this.getFactory());
    }

    protected JaxbAttributeMapping buildMapping() {
        return this.buildMapping(this.getSpecifiedMappingDefinition());
    }

    protected void syncMapping() {
        JavaAttributeMappingDefinition definition = this.getSpecifiedMappingDefinition();
        if (definition == null) {
            if (this.mapping.isDefault()) {
                this.mapping.synchronizeWithResourceModel();
            } else {
                definition = this.getDefaultMappingDefinition();
                this.setMapping(this.buildMapping(definition));
            }
        } else if (this.mapping.isDefault()) {
            this.setMapping(this.buildMapping(definition));
        } else if (this.valuesAreEqual(definition.getKey(), this.mapping.getKey())) {
            this.mapping.synchronizeWithResourceModel();
        } else {
            this.setMapping(this.buildMapping(definition));
        }
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition(String key) {
        if (key == null) {
            return null;
        }
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)key)) continue;
            return definition;
        }
        throw new IllegalArgumentException("invalid mapping key: " + key);
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition() {
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
            if (!definition.isSpecified(this)) continue;
            return definition;
        }
        return null;
    }

    protected Iterable<JavaAttributeMappingDefinition> getSpecifiedMappingDefinitions() {
        return this.getPlatform().getSpecifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMappingKey;
    }

    protected void setDefaultMappingKey(String mappingKey) {
        String old = this.defaultMappingKey;
        this.defaultMappingKey = mappingKey;
        this.firePropertyChanged("defaultMappingKey", old, mappingKey);
    }

    protected void updateMapping() {
        String newDefaultKey;
        JavaAttributeMappingDefinition definition = this.getDefaultMappingDefinition();
        String string = newDefaultKey = definition == null ? null : definition.getKey();
        if (this.mapping.isDefault() && Tools.valuesAreDifferent((Object)this.mapping.getKey(), (Object)newDefaultKey)) {
            this.setMapping(this.buildMapping(definition));
        } else {
            this.mapping.update();
        }
        this.setDefaultMappingKey(newDefaultKey);
    }

    protected JavaAttributeMappingDefinition getDefaultMappingDefinition() {
        for (DefaultJavaAttributeMappingDefinition definition : this.getDefaultMappingDefinitions()) {
            if (!definition.isDefault(this)) continue;
            return definition;
        }
        return null;
    }

    protected Iterable<DefaultJavaAttributeMappingDefinition> getDefaultMappingDefinitions() {
        return this.getPlatform().getDefaultJavaAttributeMappingDefinitions();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.mapping.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getJavaResourceAttribute().getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.getMapping().validate(messages, reporter, astRoot);
    }

    protected static String getJavaResourceAttributeType(JavaResourceAttribute attribute) {
        if (attribute.typeIsSubTypeOf(COLLECTION_CLASS_NAME)) {
            if (attribute.getTypeTypeArgumentNamesSize() == 1) {
                return attribute.getTypeTypeArgumentName(0);
            }
            return null;
        }
        return attribute.getTypeName();
    }

    protected static boolean typeIsArray(JavaResourceAttribute attribute) {
        return attribute.typeIsArray();
    }

    protected static boolean typeIsSubTypeOf(JavaResourceAttribute attribute, String typeName) {
        return attribute.typeIsSubTypeOf(typeName);
    }
}

