/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.jaxbindex;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbResourceModelProvider;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.resource.jaxbindex.JaxbIndexResourceImpl;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;

public class JaxbIndexResourceModelProvider
implements JaxbResourceModelProvider {
    private static final JaxbIndexResourceModelProvider INSTANCE = new JaxbIndexResourceModelProvider();
    private final Map<IFile, JaxbIndexResourceImpl> models = new HashMap<IFile, JaxbIndexResourceImpl>();
    private final IResourceChangeListener resourceChangeListener = this.buildResourceChangeListener();

    public static JaxbIndexResourceModelProvider instance() {
        return INSTANCE;
    }

    private JaxbIndexResourceModelProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    protected IResourceChangeListener buildResourceChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                JaxbIndexResourceModelProvider.this.handleResourceChangeEvent(event);
            }
        };
    }

    public IContentType getContentType() {
        return JptJaxbCorePlugin.JAXB_INDEX_CONTENT_TYPE;
    }

    public JptResourceModel buildResourceModel(JaxbProject jaxbProject, IFile file) {
        return this.buildResourceModel(file);
    }

    public JaxbIndexResource buildResourceModel(IFile file) {
        JaxbIndexResourceImpl resource = this.models.get(file);
        if (resource != null) {
            return resource;
        }
        resource = new JaxbIndexResourceImpl(file);
        this.models.put(file, resource);
        return resource;
    }

    protected void handleResourceChangeEvent(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                this.removeProjectResources((IProject)event.getResource());
                return;
            }
            case 1: {
                this.updateResources(event.getDelta());
            }
        }
    }

    protected void removeProjectResources(IProject removedProject) {
        for (IFile file : new SnapshotCloneIterable(this.models.keySet())) {
            if (!file.getProject().equals((Object)removedProject)) continue;
            this.removeResource(file);
        }
    }

    protected void updateResources(IResourceDelta delta) {
        try {
            delta.accept((IResourceDeltaVisitor)new ResourceDeltaVisitor());
        }
        catch (CoreException ce) {
            JptJaxbCorePlugin.log(ce);
        }
    }

    protected void removeResource(IFile file) {
        this.models.remove(file);
    }

    protected void updateResource(IFile file) {
        JaxbIndexResourceImpl resource = this.models.get(file);
        if (resource != null) {
            resource.update();
        }
    }

    protected class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    this.fileChanged((IFile)res, delta.getKind());
                    return false;
                }
            }
            return false;
        }

        protected void fileChanged(IFile file, int deltaKind) {
            if (deltaKind == 2) {
                JaxbIndexResourceModelProvider.this.removeResource(file);
            } else if (deltaKind == 4) {
                JaxbIndexResourceModelProvider.this.updateResource(file);
            }
        }
    }
}

