/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslatorPersister;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.sse.core.indexing.AbstractIndexManager;

public class JSPIndexManager
extends AbstractIndexManager {
    private static JSPIndexManager INSTANCE;
    private static final IContentType JSP_CONTENT_TYPE;
    private IPath fWorkingLocation;

    static {
        JSP_CONTENT_TYPE = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
    }

    private JSPIndexManager() {
        super(JSPCoreMessages.JSPIndexManager);
    }

    public static JSPIndexManager getDefault() {
        return INSTANCE != null ? INSTANCE : (INSTANCE = new JSPIndexManager());
    }

    protected boolean isResourceToIndex(int type, IPath path) {
        String name = path.lastSegment();
        return type == 4 || type == 2 && !name.equals("bin") && !name.startsWith(".") || JSP_CONTENT_TYPE.isAssociatedWith(path.lastSegment());
    }

    protected IPath getWorkingLocation() {
        if (this.fWorkingLocation == null) {
            IPath workingLocation = JSPCorePlugin.getDefault().getStateLocation().append("jspsearch");
            File folder = new File(workingLocation.toOSString());
            if (!folder.isDirectory()) {
                try {
                    folder.mkdir();
                }
                catch (SecurityException e) {
                    Logger.logException(String.valueOf(this.getName()) + ": Error while creating state location: " + folder + " This renders the index manager irrevocably broken for this workspace session", e);
                }
            }
            this.fWorkingLocation = workingLocation;
        }
        return this.fWorkingLocation;
    }

    protected void performAction(byte source, byte action, IResource resource, IPath movePath) {
        if (JSPTranslatorPersister.ACTIVATED && source != 1) {
            switch (action) {
                case 0: {
                    JSPTranslatorPersister.persistTranslation(resource);
                    break;
                }
                case 1: {
                    JSPTranslatorPersister.removePersistedTranslation(resource);
                    break;
                }
                case 2: {
                    JSPTranslatorPersister.movePersistedTranslation(resource, movePath);
                    break;
                }
            }
        }
        if (action == 0 || action == 2) {
            IFile file = (IFile)resource;
            JSPSearchSupport ss = JSPSearchSupport.getInstance();
            try {
                IJavaProject jproject;
                IProject project = file.getProject();
                if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
                    ss.addJspFile(file);
                }
            }
            catch (Exception e) {
                String filename = file != null ? file.getFullPath().toString() : "";
                Logger.logException("JPSIndexManger: problem indexing:" + filename, e);
            }
        }
    }
}

