/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.ArrayList;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.GenericMessages;
import org.eclipse.rse.internal.ui.view.SystemDNDTransferRunnable;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.IDropActionDelegate;

public class SystemDropActionDelegate
implements IDropActionDelegate {
    public static final String ID = "org.eclipse.rse.ui.view.DropActions";
    static /* synthetic */ Class class$0;

    public boolean run(Object data, Object target) {
        String localPath = null;
        IResource resource = null;
        if (target instanceof IProjectNature) {
            target = ((IProjectNature)target).getProject();
        }
        if (target instanceof IResource) {
            resource = (IResource)target;
            localPath = resource.getLocation().toOSString();
        } else if (target instanceof String) {
            localPath = (String)target;
        } else if (target instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = iAdaptable.getAdapter((Class)clazz)) != null && target instanceof IResource) {
                resource = (IResource)target;
                localPath = resource.getLocation().toOSString();
            }
        }
        if (localPath != null) {
            if (data instanceof byte[]) {
                byte[] result = (byte[])data;
                String[] tokens = new String(result).split("\\|");
                ArrayList<Object> srcObjects = new ArrayList<Object>();
                int i = 0;
                while (i < tokens.length) {
                    String srcStr = tokens[i];
                    Object srcObject = this.getObjectFor(srcStr);
                    srcObjects.add(srcObject);
                    ++i;
                }
                final SystemDNDTransferRunnable runnable = new SystemDNDTransferRunnable(target, srcObjects, null, 0);
                final IResource lresource = resource;
                WorkspaceJob transferAndRefreshJob = new WorkspaceJob(GenericMessages.TransferOperation_message){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        IStatus result = runnable.runInWorkspace(monitor);
                        if (lresource != null) {
                            try {
                                lresource.refreshLocal(2, null);
                            }
                            catch (CoreException coreException) {}
                        }
                        return result;
                    }
                };
                transferAndRefreshJob.schedule();
                RSEUIPlugin.getTheSystemRegistryUI().clearRunnableContext();
            }
            return true;
        }
        return false;
    }

    private Object getObjectFor(String str) {
        int profileDelim;
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        int connectionDelim = str.indexOf(":");
        if (connectionDelim == -1 && (profileDelim = str.indexOf(".")) != -1) {
            String profileId = str.substring(0, profileDelim);
            String connectionId = str.substring(profileDelim + 1, str.length());
            ISystemProfile profile = registry.getSystemProfile(profileId);
            return registry.getHost(profile, connectionId);
        }
        int subsystemDelim = str.indexOf(":", connectionDelim + 1);
        if (subsystemDelim == -1) {
            return registry.getSubSystem(str);
        }
        String subSystemId = str.substring(0, subsystemDelim);
        String srcKey = str.substring(subsystemDelim + 1, str.length());
        ISubSystem subSystem = registry.getSubSystem(subSystemId);
        if (subSystem != null) {
            Object result = null;
            try {
                result = subSystem.getObjectWithAbsoluteName(srcKey);
            }
            catch (SystemMessageException e) {
                return e.getSystemMessage();
            }
            catch (Exception exception) {}
            if (result != null) {
                return result;
            }
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1106");
            msg.makeSubstitution((Object)srcKey, (Object)subSystem.getHostAliasName());
            return msg;
        }
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1103");
        msg.makeSubstitution((Object)subSystemId);
        return msg;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        irc = new ProgressMonitorDialog(shell);
        RSEUIPlugin.getTheSystemRegistryUI().setRunnableContext(shell, irc);
        return irc;
    }
}

