/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.XmlFile;
import org.eclipse.jpt.jpa.core.resource.xml.JpaRootEObject;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpgradeXmlFileVersionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            this.upgradeXmlFileVersion(selectedObject);
            ++n2;
        }
        return null;
    }

    protected void upgradeXmlFileVersion(Object selectedObject) {
        XmlFile xmlFile;
        JpaXmlResource xmlResource = (JpaXmlResource)Platform.getAdapterManager().getAdapter(selectedObject, JpaXmlResource.class);
        if (xmlResource == null && (xmlFile = (XmlFile)Platform.getAdapterManager().getAdapter(selectedObject, XmlFile.class)) != null) {
            xmlResource = xmlFile.getXmlResource();
        }
        if (xmlResource == null) {
            return;
        }
        final JpaRootEObject root = xmlResource.getRootObject();
        IContentType contentType = xmlResource.getContentType();
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)xmlResource.getProject());
        final String newVersion = jpaProject.getJpaPlatform().getMostRecentSupportedResourceType(contentType).getVersion();
        xmlResource.modify(new Runnable(){

            public void run() {
                root.setVersion(newVersion);
            }
        });
    }
}

