/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.operation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.AccessType;
import org.eclipse.jpt.jpa.core.resource.orm.InheritanceType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.AnnotatedEntityTemplate;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityTemplate;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.IdClassTemplate;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model.CreateEntityTemplateModel;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.osgi.framework.Bundle;

public class NewEntityClassOperation
extends AbstractDataModelOperation {
    private static final String DOT_JAVA = ".java";
    private static final String SEPARATOR = "/";
    private static final String VERSION_STRING = "1.0";
    private static final String FIELD = "FIELD";
    private static final String PROPERTY = "PROPERTY";
    protected static final String WTP_CUSTOMIZATION_PLUGIN = "WTP_CUSTOMIZATION_PLUGIN";
    protected static final String ANNOTATED_ENTITY_TEMPLATE_FILE = "/templates/annotated_entity.javajet";
    protected static final String ENTITY_TEMPLATE_FILE = "/templates/entity.javajet";
    protected static final String IDCLASS_TEMPLATE_FILE = "/templates/idClass.javajet";
    protected static final String BUILDER_ID = "builderId";
    private static final String EMPTY_STRING = "";
    private static final String SINGLE_TABLE = "SINGLE_TABLE";
    protected static final String GENERATE_METHOD = "generate";

    public NewEntityClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createJavaSourceContainer();
        IPackageFragment pack = this.createJavaPackage();
        try {
            this.generateUsingTemplates(monitor, pack);
        }
        catch (Exception e) {
            return WTPCommonPlugin.createErrorStatus((String)e.toString());
        }
        return OK_STATUS;
    }

    protected final IPackageFragment createJavaPackage() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment(EMPTY_STRING);
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                JptJpaUiPlugin.log(e);
            }
        }
        return pack;
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
        CreateEntityTemplateModel tempModel = this.createTemplateModel();
        IProject project = this.getTargetProject();
        String entityClassSource = null;
        String idClassSource = null;
        try {
            Object tempImpl;
            if (tempModel.isArtifactsAnnotated()) {
                tempImpl = AnnotatedEntityTemplate.create(null);
                entityClassSource = this.generateTemplateSource(tempModel, ANNOTATED_ENTITY_TEMPLATE_FILE, tempImpl, monitor);
            } else {
                tempImpl = EntityTemplate.create(null);
                entityClassSource = this.generateTemplateSource(tempModel, ENTITY_TEMPLATE_FILE, tempImpl, monitor);
            }
            if (tempModel.isCompositePK()) {
                tempImpl = IdClassTemplate.create(null);
                idClassSource = this.generateTemplateSource(tempModel, IDCLASS_TEMPLATE_FILE, tempImpl, monitor);
            }
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
        if (fragment != null) {
            String entityPKName;
            ICompilationUnit cu1;
            AnnotationsController controller;
            String javaFileName = String.valueOf(tempModel.getClassName()) + DOT_JAVA;
            ICompilationUnit cu = fragment.getCompilationUnit(javaFileName);
            if (cu == null || !cu.exists()) {
                cu = fragment.createCompilationUnit(javaFileName, entityClassSource, true, monitor);
            }
            IFile aFile = (IFile)cu.getResource();
            if (tempModel.isArtifactsAnnotated() && (controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(project)) != null) {
                controller.process((IResource)aFile);
            }
            if (!(idClassSource == null || (cu1 = fragment.getCompilationUnit(entityPKName = String.valueOf(tempModel.getIdClassName()) + DOT_JAVA)) != null && cu1.exists())) {
                cu1 = fragment.createCompilationUnit(entityPKName, idClassSource, true, monitor);
            }
        }
        if (!tempModel.isArtifactsAnnotated()) {
            if (tempModel.isNonEntitySuperclass()) {
                this.addMappedSuperclassToXML(tempModel, project).schedule();
            } else {
                this.addEntityToXML(tempModel, project).schedule();
            }
        }
        if (tempModel.isArtifactsAnnotated() && !JptJpaCorePlugin.discoverAnnotatedClasses((IProject)project)) {
            this.registerClassInPersistenceXml(tempModel, project).schedule();
        }
    }

    private CreateEntityTemplateModel createTemplateModel() {
        CreateEntityTemplateModel templateModel = new CreateEntityTemplateModel(this.model);
        return templateModel;
    }

    private String generateTemplateSource(CreateEntityTemplateModel templateModel, String templateFile, Object templateImpl, IProgressMonitor monitor) throws JETException, SecurityException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Preferences preferences = J2EEPlugin.getDefault().getPluginPreferences();
        boolean dynamicTranslation = preferences.getBoolean("dynamicTranslationOfJetTemplates");
        if (dynamicTranslation) {
            URL templateURL = FileLocator.find((Bundle)JptJpaUiPlugin.instance().getBundle(), (IPath)new Path(templateFile), null);
            this.cleanUpOldEmitterProject();
            WTPJETEmitter emitter = new WTPJETEmitter(templateURL.toString(), ((Object)((Object)this)).getClass().getClassLoader());
            emitter.setIntelligentLinkingEnabled(true);
            emitter.addVariable(WTP_CUSTOMIZATION_PLUGIN, "org.eclipse.jpt.jpa.ui");
            return emitter.generate(monitor, new Object[]{templateModel});
        }
        Method method = templateImpl.getClass().getMethod(GENERATE_METHOD, Object.class);
        return (String)method.invoke(templateImpl, templateModel);
    }

    private void cleanUpOldEmitterProject() {
        IProject project = ProjectUtilities.getProject((String)".JETEmitters");
        if (project == null || !project.exists()) {
            return;
        }
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
            int i = 0;
            int l = markers.length;
            while (i < l) {
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final IContainer createJavaSourceContainer() {
        String containerFullPath = this.model.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = PlatformTools.getContainer((IPath)new Path(containerFullPath));
        if (!container.exists()) {
            try {
                ((IFolder)container).create(true, true, null);
            }
            catch (CoreException e) {
                JptJpaUiPlugin.log(e);
            }
        }
        return container;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doExecute(monitor, info);
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    private Job addEntityToXML(final CreateEntityTemplateModel model, final IProject project) {
        Job job = new Job(EntityWizardMsg.ADD_ENTITY_TO_XML){

            protected IStatus run(IProgressMonitor monitor) {
                JpaXmlResource xmlResource = NewEntityClassOperation.this.getOrmXmlResource(model, project);
                EntityMappings entityMappings = (EntityMappings)JptJpaCorePlugin.getJpaProject((IProject)project).getJpaFile(xmlResource.getFile()).getRootStructureNodes().iterator().next();
                OrmPersistentType persistentType = entityMappings.addPersistentType("entity", model.getQualifiedJavaClassName());
                Entity entity = (Entity)persistentType.getMapping();
                if (model.isInheritanceSet()) {
                    entity.setSpecifiedInheritanceStrategy(NewEntityClassOperation.this.getModelInheritanceType(model));
                }
                if (model.isEntityNameSet()) {
                    entity.setSpecifiedName(model.getEntityName());
                }
                if (model.isTableNameSet()) {
                    entity.getTable().setSpecifiedName(model.getTableName());
                }
                if (model.isCompositePK()) {
                    entity.getIdClassReference().setSpecifiedIdClassName(model.getIdClassName());
                }
                for (String fieldName : model.getPKFields()) {
                    persistentType.getAttributeNamed(fieldName).convertToSpecified("id");
                }
                persistentType.setSpecifiedAccess(NewEntityClassOperation.this.getModelAccessType(model));
                try {
                    xmlResource.saveIfNecessary();
                }
                catch (Exception e) {
                    JptJpaUiPlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    protected JpaXmlResource getOrmXmlResource(CreateEntityTemplateModel model, IProject project) {
        if (model.isMappingXMLDefault()) {
            return JptJpaCorePlugin.getJpaProject((IProject)project).getDefaultOrmXmlResource();
        }
        return JptJpaCorePlugin.getJpaProject((IProject)project).getMappingFileXmlResource((IPath)new Path(model.getMappingXMLName()));
    }

    private Job addMappedSuperclassToXML(final CreateEntityTemplateModel model, final IProject project) {
        Job job = new Job(EntityWizardMsg.ADD_MAPPED_SUPERCLASS_TO_XML){

            protected IStatus run(IProgressMonitor monitor) {
                JpaXmlResource xmlResource = NewEntityClassOperation.this.getOrmXmlResource(model, project);
                EntityMappings entityMappings = (EntityMappings)JptJpaCorePlugin.getJpaProject((IProject)project).getJpaFile(xmlResource.getFile()).getRootStructureNodes().iterator().next();
                OrmPersistentType persistentType = entityMappings.addPersistentType("mappedSuperclass", model.getQualifiedJavaClassName());
                MappedSuperclass mappedSuperclass = (MappedSuperclass)persistentType.getMapping();
                if (model.isCompositePK()) {
                    mappedSuperclass.getIdClassReference().setSpecifiedIdClassName(model.getIdClassName());
                }
                for (String fieldName : model.getPKFields()) {
                    persistentType.getAttributeNamed(fieldName).convertToSpecified("id");
                }
                persistentType.setSpecifiedAccess(NewEntityClassOperation.this.getModelAccessType(model));
                try {
                    xmlResource.saveIfNecessary();
                }
                catch (Exception e) {
                    JptJpaUiPlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    protected org.eclipse.jpt.jpa.core.context.AccessType getModelAccessType(CreateEntityTemplateModel model) {
        String accessTypeString = FIELD;
        if (!model.isFieldAccess()) {
            accessTypeString = PROPERTY;
        }
        return org.eclipse.jpt.jpa.core.context.AccessType.fromOrmResourceModel((AccessType)OrmFactory.eINSTANCE.createAccessTypeFromString(null, accessTypeString));
    }

    protected org.eclipse.jpt.jpa.core.context.InheritanceType getModelInheritanceType(CreateEntityTemplateModel model) {
        String inheritanceStrategy = model.getInheritanceStrategyName();
        if (inheritanceStrategy.equals(EMPTY_STRING)) {
            inheritanceStrategy = SINGLE_TABLE;
        }
        return org.eclipse.jpt.jpa.core.context.InheritanceType.fromOrmResourceModel((InheritanceType)OrmFactory.eINSTANCE.createInheritanceTypeFromString(null, inheritanceStrategy));
    }

    private Job registerClassInPersistenceXml(final CreateEntityTemplateModel model, final IProject project) {
        Job job = new Job(EntityWizardMsg.APPLY_CHANGES_TO_PERSISTENCE_XML){

            protected IStatus run(IProgressMonitor monitor) {
                JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)project);
                final JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
                resource.modify(new Runnable(){

                    public void run() {
                        XmlPersistence xmlPersistence = (XmlPersistence)resource.getRootObject();
                        EList persistenceUnits = xmlPersistence.getPersistenceUnits();
                        XmlPersistenceUnit persistenceUnit = (XmlPersistenceUnit)persistenceUnits.get(0);
                        if (!model.isNonEntitySuperclass()) {
                            XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
                            classRef.setJavaClass(model.getQualifiedJavaClassName());
                            persistenceUnit.getClasses().add((Object)classRef);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private String getLastSegment(String input) {
        String output = input;
        if (input.indexOf(SEPARATOR) != -1) {
            output = input.substring(input.lastIndexOf(SEPARATOR) + 1);
        }
        return output;
    }
}

