/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.converter.IDOMFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.converter.PreferenceReader;
import org.eclipse.jst.pagedesigner.css2.style.ITagEditInfo;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.preview.PageExpressionContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractTagConverter
implements ITagConverter,
ITagEditInfo,
INodeAdapter,
IDOMFactory {
    private IDOMDocument _targetDocument;
    private Element _hostElement;
    private Element _resultElement;
    private List _childNodes = Collections.EMPTY_LIST;
    private Map _childNodePositions = Collections.EMPTY_MAP;
    private int _mode;
    private int _minWidth;
    private int _minHeight;
    private boolean _needBorderDecorator;

    public AbstractTagConverter(Element host) {
        this._hostElement = host;
    }

    public void setDestDocument(IDOMDocument document) {
        this._targetDocument = document;
    }

    public final void convertRefresh(Object context) {
        this._resultElement = null;
        this._childNodes = new ArrayList();
        this._childNodePositions = new HashMap();
        this._resultElement = this.doConvertRefresh();
        if (this._resultElement instanceof INodeNotifier) {
            ((INodeNotifier)this._resultElement).addAdapter((INodeAdapter)this);
        }
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    protected abstract Element doConvertRefresh();

    public final Element getHostElement() {
        return this._hostElement;
    }

    public final Element getResultElement() {
        return this._resultElement;
    }

    public final List getChildModeList() {
        return this._childNodes;
    }

    public List getNonVisualChildren() {
        return Collections.EMPTY_LIST;
    }

    protected void addChild(Node childNode, ConvertPosition position) {
        this._childNodes.add(childNode);
        this._childNodePositions.put(childNode, position);
    }

    public final ConvertPosition getChildVisualPosition(Node childModel) {
        return (ConvertPosition)this._childNodePositions.get(childModel);
    }

    public boolean isVisualByHTML() {
        return true;
    }

    public Image getVisualImage() {
        return null;
    }

    public void dispose() {
    }

    protected boolean shouldIgnore(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    protected void copyChildren(Element src, Element dest) {
        Node node = src.getFirstChild();
        int index = 0;
        while (node != null) {
            if (!this.shouldIgnore(node)) {
                this.addChild(node, new ConvertPosition(dest, index++));
            }
            node = node.getNextSibling();
        }
    }

    protected void dumCopyChildren(Element src, Element dest) {
        Node node = src.getFirstChild();
        Document destDoc = dest.getOwnerDocument();
        while (node != null) {
            if (!this.shouldIgnore(node)) {
                Node n = DOMUtil.cloneNodeDeepIgnoreError(destDoc, node);
                dest.appendChild(n);
            }
            node = node.getNextSibling();
        }
    }

    public IDOMDocument getDestDocument() {
        if (this._targetDocument != null) {
            return this._targetDocument;
        }
        return (IDOMDocument)this._hostElement.getOwnerDocument();
    }

    public Element createElement(String tagName) {
        return this.getDestDocument().createElement(tagName);
    }

    public Text createText(String text) {
        return this.getDestDocument().createTextNode(text);
    }

    protected String mapURL(String original) {
        return original;
    }

    protected String mapValue(String value) {
        if (value == null) {
            return null;
        }
        if (this.isDesignerMode()) {
            int checkPos = value.indexOf("#{");
            if (checkPos != -1) {
                String mapValue = "";
                int preferType = PreferenceReader.getMapValueType();
                switch (preferType) {
                    case 0: {
                        mapValue = value;
                        break;
                    }
                    case 1: {
                        String strBackup = value;
                        StringBuffer sb = new StringBuffer();
                        while (strBackup.indexOf("#{") != -1) {
                            int pos = strBackup.indexOf("#{");
                            int endBracketPos = strBackup.indexOf("}", pos + 1);
                            if (endBracketPos == -1) break;
                            sb.append(strBackup.substring(0, pos + 2));
                            String exp = strBackup.substring(pos + 2, endBracketPos);
                            if (this.allowTrim(exp)) {
                                int lastDotPos = exp.lastIndexOf(".");
                                if (lastDotPos != -1) {
                                    String convertedExp = exp.substring(lastDotPos + 1);
                                    sb.append(convertedExp);
                                } else {
                                    sb.append(exp);
                                }
                            } else {
                                sb.append(exp);
                            }
                            sb.append("}");
                            if (strBackup.length() > endBracketPos + 1) {
                                strBackup = strBackup.substring(endBracketPos + 1);
                                continue;
                            }
                            strBackup = "";
                            break;
                        }
                        sb.append(strBackup);
                        mapValue = sb.toString();
                        break;
                    }
                    default: {
                        mapValue = value;
                    }
                }
                return mapValue;
            }
        } else {
            try {
                HashMap<String, Element> options = new HashMap<String, Element>();
                options.put("ELEMENT", this._hostElement);
                return (String)PageExpressionContext.getCurrent().evaluateExpression(value, String.class, options);
            }
            catch (Exception exception) {}
        }
        return value;
    }

    public boolean needBorderDecorator() {
        return this._needBorderDecorator;
    }

    public void setNeedBorderDecorator(boolean b) {
        this._needBorderDecorator = b;
    }

    public boolean needTableDecorator() {
        return false;
    }

    public boolean isAdapterForType(Object type) {
        return type == ITagEditInfo.class;
    }

    public final void setMode(int mode) {
        this._mode = mode;
    }

    public final boolean isPreviewMode() {
        return this._mode == 1;
    }

    public final boolean isDesignerMode() {
        return this._mode == 0;
    }

    public final int getMode() {
        return this._mode;
    }

    private boolean allowTrim(String expression) {
        int i = 0;
        int size = expression.length();
        while (i < size) {
            char ch = expression.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '.' && ch != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getMinWidth() {
        return this._minWidth;
    }

    public void setMinWidth(int minWidth) {
        this._minWidth = minWidth;
    }

    public int getMinHeight() {
        return this._minHeight;
    }

    public void setMinHeight(int minHeight) {
        this._minHeight = minHeight;
    }

    public static boolean hasAttribute(Element element, String attrname) {
        return element.hasAttribute(attrname);
    }
}

