/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigureLayout;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;

public abstract class FlowContainerLayout
extends FlowFigureLayout
implements FlowContext {
    protected LineBox _currentLine;
    private boolean _calculatingMaxWidth;

    protected FlowContainerLayout(FlowFigure flowFigure) {
        super(flowFigure);
    }

    public void addToCurrentLine(FlowBox block) {
        this.getCurrentLine().add(block);
    }

    protected abstract void createNewLine();

    protected void createNewLine(int topMargin) {
        this.createNewLine();
    }

    public LineBox getCurrentLine() {
        if (this._currentLine == null) {
            this.createNewLine();
        }
        return this._currentLine;
    }

    public LineBox getCurrentLine(int topMargin) {
        if (this._currentLine == null) {
            this.createNewLine(topMargin);
        } else if (this._currentLine.isEmptyStringLine()) {
            List list = this._currentLine.getFragments();
            this.createNewLine(topMargin);
            this._currentLine._fragments.addAll(list);
        }
        return this._currentLine;
    }

    public boolean isCurrentLineOccupied() {
        return this._currentLine != null && this._currentLine.isOccupied();
    }

    protected void layout() {
        this.preLayout();
        this.layoutChildren();
        this.flush();
        this.cleanup();
    }

    protected void layoutChildren() {
        List children = this.getFlowFigure().getChildren();
        int i = 0;
        while (i < children.size()) {
            Figure f = (Figure)children.get(i);
            f.invalidate();
            f.validate();
            ++i;
        }
    }

    public int getLastMarginRight() {
        if (this._currentLine == null || !this._currentLine.isOccupied()) {
            return 0;
        }
        FlowBox box = (FlowBox)this._currentLine.getFragments().get(this._currentLine.getFragments().size() - 1);
        if (box != null) {
            return box.getMarginInsets().right;
        }
        return 0;
    }

    public boolean isCalculatingMaxWidth() {
        if (this._calculatingMaxWidth) {
            return true;
        }
        if (this.getFlowContext() == null) {
            return false;
        }
        return this.getFlowContext().isCalculatingMaxWidth();
    }

    protected abstract void preLayout();

    protected abstract void flush();

    protected abstract void cleanup();
}

