/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.common.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.common.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.common.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.TreeChangeListener;
import org.eclipse.swt.widgets.Display;

public class SWTTreeChangeListenerWrapper
implements TreeChangeListener {
    private final TreeChangeListener listener;

    public SWTTreeChangeListenerWrapper(TreeChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void nodeAdded(TreeAddEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.nodeAdded_(event);
        } else {
            this.executeOnUIThread(this.buildNodeAddedRunnable(event));
        }
    }

    public void nodeRemoved(TreeRemoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.nodeRemoved_(event);
        } else {
            this.executeOnUIThread(this.buildNodeRemovedRunnable(event));
        }
    }

    public void treeCleared(TreeClearEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.treeCleared_(event);
        } else {
            this.executeOnUIThread(this.buildTreeClearedRunnable(event));
        }
    }

    public void treeChanged(TreeChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.treeChanged_(event);
        } else {
            this.executeOnUIThread(this.buildTreeChangedRunnable(event));
        }
    }

    private Runnable buildNodeAddedRunnable(final TreeAddEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.nodeAdded_(event);
            }

            public String toString() {
                return "node added runnable";
            }
        };
    }

    private Runnable buildNodeRemovedRunnable(final TreeRemoveEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.nodeRemoved_(event);
            }

            public String toString() {
                return "node removed runnable";
            }
        };
    }

    private Runnable buildTreeClearedRunnable(final TreeClearEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.treeCleared_(event);
            }

            public String toString() {
                return "tree cleared runnable";
            }
        };
    }

    private Runnable buildTreeChangedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.treeChanged_(event);
            }

            public String toString() {
                return "tree changed runnable";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return Display.getCurrent() != null;
    }

    private void executeOnUIThread(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    void nodeAdded_(TreeAddEvent event) {
        this.listener.nodeAdded(event);
    }

    void nodeRemoved_(TreeRemoveEvent event) {
        this.listener.nodeRemoved(event);
    }

    void treeCleared_(TreeClearEvent event) {
        this.listener.treeCleared(event);
    }

    void treeChanged_(TreeChangeEvent event) {
        this.listener.treeChanged(event);
    }

    public String toString() {
        return "SWT(" + this.listener.toString() + ')';
    }
}

