/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTime
extends AbstractExpression {
    DateTime(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return DateTime.queryBNF("functions_returning_datetime");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public boolean isCurrentDate() {
        return this.getText() == "CURRENT_DATE";
    }

    public boolean isCurrentTime() {
        return this.getText() == "CURRENT_TIME";
    }

    public boolean isCurrentTimestamp() {
        return this.getText() == "CURRENT_TIMESTAMP";
    }

    public boolean isJDBCDate() {
        return this.getText().charAt(0) == '{';
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWith('{')) {
            this.parseJDBCEscapeFormat(wordParser);
        } else {
            String identifier = this.parseIdentifier(wordParser);
            this.setText(identifier);
            wordParser.moveForward(identifier);
        }
    }

    private String parseIdentifier(WordParser wordParser) {
        int position = wordParser.position();
        if (wordParser.character(position + 8) == 'D') {
            return "CURRENT_DATE";
        }
        if (wordParser.character(position + 12) == 'S') {
            return "CURRENT_TIMESTAMP";
        }
        return "CURRENT_TIME";
    }

    private void parseJDBCEscapeFormat(WordParser wordParser) {
        int startIndex = wordParser.position();
        int stopIndex = startIndex + 1;
        int length = wordParser.length();
        for (int index = startIndex + 1; index < length; ++index) {
            char character = wordParser.character(index);
            if (character == '}') {
                stopIndex = index + 1;
                break;
            }
            ++stopIndex;
        }
        this.setText(wordParser.substring(startIndex, stopIndex));
        wordParser.moveForward(stopIndex - startIndex);
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
    }
}

