/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrimExpression
extends AbstractSingleEncapsulatedExpression {
    private boolean hasFrom;
    private boolean hasSpaceAfterFrom;
    private boolean hasSpaceAfterSpecification;
    private boolean hasSpaceAfterTrimCharacter;
    private Specification specification;
    private AbstractExpression trimCharacter;

    TrimExpression(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getTrimCharacter().accept(visitor);
        super.acceptChildren(visitor);
    }

    @Override
    void addOrderedEncapsulatedExpressionTo(List<StringExpression> children) {
        if (this.hasSpecification()) {
            children.add(this.buildStringExpression(this.specification.name()));
        }
        if (this.hasSpaceAfterSpecification) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasTrimCharacter()) {
            children.add(this.trimCharacter);
        }
        if (this.hasSpaceAfterTrimCharacter) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasFrom) {
            children.add(this.buildStringExpression("FROM"));
        }
        if (this.hasSpaceAfterFrom) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    @Override
    public String encapsulatedExpressionBNF() {
        return "string_primary";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return TrimExpression.queryBNF("functions_returning_strings");
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public Expression getTrimCharacter() {
        if (this.trimCharacter == null) {
            this.trimCharacter = this.buildNullExpression();
        }
        return this.trimCharacter;
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasSpecification() || this.hasTrimCharacter() || this.hasFrom || this.hasExpression();
    }

    public boolean hasFrom() {
        return this.hasFrom;
    }

    public boolean hasSpaceAfterFrom() {
        return this.hasSpaceAfterFrom;
    }

    public boolean hasSpaceAfterSpecification() {
        return this.hasSpaceAfterSpecification;
    }

    public boolean hasSpaceAfterTrimCharacter() {
        return this.hasSpaceAfterTrimCharacter;
    }

    public boolean hasSpecification() {
        return this.specification != Specification.DEFAULT;
    }

    public boolean hasTrimCharacter() {
        return this.trimCharacter != null && !this.trimCharacter.isNull();
    }

    @Override
    void parseEncapsulatedExpression(WordParser wordParser, boolean tolerant) {
        this.specification = this.parseTrimSpecification(wordParser);
        if (this.specification != Specification.DEFAULT) {
            wordParser.moveForward(this.specification.name().length());
            boolean bl = this.hasSpaceAfterSpecification = wordParser.skipLeadingWhitespace() > 0;
        }
        if (!wordParser.startsWithIdentifier("FROM")) {
            this.trimCharacter = this.parse(wordParser, (JPQLQueryBNF)TrimExpression.queryBNF("pre_literal"), tolerant);
        }
        if (this.hasTrimCharacter()) {
            this.hasSpaceAfterTrimCharacter = wordParser.skipLeadingWhitespace() > 0;
        }
        this.hasFrom = wordParser.startsWithIdentifier("FROM");
        if (this.hasFrom) {
            wordParser.moveForward("FROM");
            this.hasSpaceAfterFrom = wordParser.skipLeadingWhitespace() > 0;
        }
        super.parseEncapsulatedExpression(wordParser, tolerant);
        if (!this.hasFrom && !this.hasExpression() && this.hasTrimCharacter()) {
            this.setExpression(this.trimCharacter);
            this.trimCharacter = null;
            if (this.hasSpaceAfterTrimCharacter) {
                this.hasSpaceAfterTrimCharacter = false;
                wordParser.moveBackward(1);
            }
        }
    }

    @Override
    String parseIdentifier(WordParser wordParser) {
        return "TRIM";
    }

    private Specification parseTrimSpecification(WordParser wordParser) {
        if (wordParser.startsWithIdentifier("BOTH")) {
            return Specification.BOTH;
        }
        if (wordParser.startsWithIdentifier("LEADING")) {
            return Specification.LEADING;
        }
        if (wordParser.startsWithIdentifier("TRAILING")) {
            return Specification.TRAILING;
        }
        return Specification.DEFAULT;
    }

    @Override
    void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean includeVirtual) {
        if (this.hasSpecification()) {
            writer.append((Object)this.specification);
        }
        if (this.hasSpaceAfterSpecification) {
            writer.append(' ');
        }
        if (this.hasTrimCharacter()) {
            this.trimCharacter.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterTrimCharacter) {
            writer.append(' ');
        }
        if (this.hasFrom) {
            writer.append("FROM");
        }
        if (this.hasSpaceAfterFrom) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, includeVirtual);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Specification {
        BOTH,
        DEFAULT,
        LEADING,
        TRAILING;

    }
}

