/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.eclipselink.core.internal.libval;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jpt.common.eclipselink.core.internal.JptCommonEclipseLinkCoreMessages;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLibValUtil {
    private static final String VERSION_CLASS_PATH = "org/eclipse/persistence/Version.class";
    private static final String VERSION_FIELD_NAME = "version";

    public static IStatus validate(Iterable<IClasspathEntry> libraryEntries, Set<VersionRange> versionRanges) {
        Version version = null;
        for (IClasspathEntry entry : libraryEntries) {
            String versionString = null;
            if (entry.getEntryKind() != 1) continue;
            IClassFileReader classReader = ToolFactory.createDefaultClassFileReader((String)entry.getPath().toFile().getAbsolutePath(), (String)VERSION_CLASS_PATH, (int)5);
            if (classReader != null) {
                IFieldInfo[] iFieldInfoArray = classReader.getFieldInfos();
                int n = iFieldInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFieldInfo field = iFieldInfoArray[n2];
                    if (StringTools.stringsAreEqual((char[])field.getName(), (char[])VERSION_FIELD_NAME.toCharArray())) {
                        try {
                            versionString = field.getConstantValueAttribute().getConstantValue().getStringValue();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    ++n2;
                }
            }
            if (versionString == null) continue;
            if (version != null) {
                return new Status(4, "org.eclipse.jpt.common.eclipselink.core", JptCommonEclipseLinkCoreMessages.EclipseLinkLibraryValidator_multipleEclipseLinkVersions);
            }
            version = new Version(versionString);
        }
        if (version == null) {
            return new Status(4, "org.eclipse.jpt.common.eclipselink.core", JptCommonEclipseLinkCoreMessages.EclipseLinkLibraryValidator_noEclipseLinkVersion);
        }
        for (VersionRange versionRange : versionRanges) {
            if (versionRange.isIncluded(version)) continue;
            return new Status(4, "org.eclipse.jpt.common.eclipselink.core", JptCommonEclipseLinkCoreMessages.EclipseLinkLibraryValidator_improperEclipseLinkVersion);
        }
        return Status.OK_STATUS;
    }
}

