/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ExpressionBuilder
extends ObjectExpression {
    protected transient AbstractSession session;
    protected Class queryClass;
    protected SQLSelectStatement statement;
    protected DatabaseTable viewTable;
    protected DatabaseTable aliasedViewTable;
    protected boolean wasQueryClassSetInternally = true;
    protected boolean wasAdditionJoinCriteriaUsed = false;

    public ExpressionBuilder() {
    }

    public ExpressionBuilder(Class queryClass) {
        this.queryClass = queryClass;
        this.wasQueryClassSetInternally = false;
    }

    public boolean equals(Object expression) {
        if (this == expression) {
            return true;
        }
        return super.equals(expression) && this.getQueryClass() == null && ((ExpressionBuilder)expression).getQueryClass() == null;
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        if (this.hasViewTable()) {
            return this.getAliasedViewTable();
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            Enumeration e = this.derivedTables.elements();
            while (e.hasMoreElements()) {
                TableExpression t = (TableExpression)e.nextElement();
                DatabaseTable result = t.aliasForTable(table);
                if (result == null) continue;
                return result;
            }
        } else {
            return super.aliasForTable(table);
        }
        return null;
    }

    public int assignTableAliasesStartingAt(int initialValue) {
        if (this.hasBeenAliased()) {
            return initialValue;
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            return initialValue;
        }
        if (this.hasViewTable()) {
            DatabaseTable aliased = this.viewTable.clone();
            String alias = "t" + initialValue;
            aliased.setName(alias);
            this.assignAlias(alias, this.viewTable);
            this.aliasedViewTable = aliased;
            return initialValue + 1;
        }
        return super.assignTableAliasesStartingAt(initialValue);
    }

    public String descriptionOfNodeType() {
        return "Base";
    }

    public boolean doesNotRepresentAnObjectInTheQuery() {
        return this.hasDerivedTables() && !this.hasDerivedFields() && !this.hasDerivedExpressions();
    }

    public DatabaseTable getAliasedViewTable() {
        return this.aliasedViewTable;
    }

    public ExpressionBuilder getBuilder() {
        return this;
    }

    public ClassDescriptor getDescriptor() {
        if (this.descriptor == null) {
            if (this.getQueryClass() == null) {
                return null;
            }
            if (this.getSession() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            this.descriptor = this.getSession().getDescriptor(this.getQueryClass());
            this.descriptor = this.convertToCastDescriptor(this.descriptor, this.getSession());
        }
        return this.descriptor;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public DatabaseTable getViewTable() {
        return this.viewTable;
    }

    public boolean hasViewTable() {
        return this.viewTable != null;
    }

    public boolean isExpressionBuilder() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.hasBeenNormalized()) {
            return this;
        }
        this.setHasBeenNormalized(true);
        if (this.queryClass != null) {
            Expression criteria = null;
            this.setSession(normalizer.getSession().getRootSession(null));
            if (this.getDescriptor() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            if (!this.wasAdditionJoinCriteriaUsed && (criteria = this.getDescriptor().getQueryManager().getAdditionalJoinExpression()) != null) {
                criteria = this.twist(criteria, this);
            }
            if (this.isUsingOuterJoinForMultitableInheritance() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                Expression childrenCriteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
                childrenCriteria = this.twist(childrenCriteria, this);
                childrenCriteria.convertToUseOuterJoin();
                criteria = criteria == null ? childrenCriteria : criteria.and(childrenCriteria);
            }
            if (this.isUsingOuterJoinForMultitableInheritance() && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                normalizer.getStatement().getOuterJoinExpressions().addElement(null);
                normalizer.getStatement().getOuterJoinedMappingCriteria().addElement(null);
                normalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                normalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(this.getDescriptor());
            }
            normalizer.addAdditionalExpression(criteria);
        }
        this.setStatement(normalizer.getStatement());
        if (this.getAsOfClause() == null) {
            this.asOf(AsOfClause.NO_CLAUSE);
        }
        if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null) {
            Expression temporalCriteria = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this);
            normalizer.addAdditionalExpression(temporalCriteria);
        }
        return super.normalize(normalizer);
    }

    public void printJava(ExpressionJavaPrinter printer) {
        printer.printString(printer.getBuilderString());
    }

    public Expression rebuildOn(Expression newBase) {
        return newBase;
    }

    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
    }

    protected Expression registerIn(Map alreadyDone) {
        Object value = alreadyDone.get(alreadyDone);
        if (value == null || value == alreadyDone) {
            return super.registerIn(alreadyDone);
        }
        ObjectExpression copy = (ObjectExpression)value;
        alreadyDone.put(alreadyDone, alreadyDone);
        alreadyDone.put(this, copy);
        if (this.derivedExpressions != null) {
            if (copy.derivedExpressions == null) {
                copy.derivedExpressions = this.copyCollection(this.derivedExpressions, alreadyDone);
            } else {
                copy.derivedExpressions.addAll(this.copyCollection(this.derivedExpressions, alreadyDone));
            }
        }
        copy.postCopyIn(alreadyDone, this.derivedFields, this.derivedTables);
        return copy;
    }

    public void setQueryClass(Class queryClass) {
        this.queryClass = queryClass;
        this.descriptor = null;
    }

    public void setQueryClassAndDescriptor(Class queryClass, ClassDescriptor descriptor) {
        this.queryClass = queryClass;
        this.descriptor = this.convertToCastDescriptor(descriptor, this.session);
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setStatement(SQLSelectStatement statement) {
        this.statement = statement;
    }

    public void setViewTable(DatabaseTable theTable) {
        this.viewTable = theTable;
    }

    public void setWasAdditionJoinCriteriaUsed(boolean joinCriteriaUsed) {
        this.wasAdditionJoinCriteriaUsed = joinCriteriaUsed;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        return newBase;
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        return object;
    }

    public boolean wasAdditionJoinCriteriaUsed() {
        return this.wasAdditionJoinCriteriaUsed;
    }

    public boolean wasQueryClassSetInternally() {
        return this.wasQueryClassSetInternally;
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        String className = this.getQueryClass() == null ? "QUERY OBJECT" : this.getQueryClass().getName();
        writer.write(className + this.tableAliasesDescription());
    }
}

