/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;

public final class ClassName {
    public static final String VOID_CLASS_NAME = ReflectionTools.VOID_CLASS.getName();
    public static final String VOID_WRAPPER_CLASS_NAME = ReflectionTools.VOID_WRAPPER_CLASS.getName();
    public static final char REFERENCE_CLASS_CODE = 'L';
    public static final char REFERENCE_CLASS_NAME_DELIMITER = ';';

    public static boolean isArray(String className) {
        return className.charAt(0) == '[';
    }

    public static String getElementTypeName(String className) {
        int depth = ClassName.getArrayDepth(className);
        if (depth == 0) {
            return className;
        }
        return ClassName.getElementTypeName_(className, depth);
    }

    private static String getElementTypeName_(String className, int arrayDepth) {
        int last = className.length() - 1;
        if (className.charAt(arrayDepth) == 'L') {
            return className.substring(arrayDepth + 1, last);
        }
        return ClassName.forCode(className.charAt(last));
    }

    public static int getArrayDepth(String className) {
        int depth = 0;
        while (className.charAt(depth) == '[') {
            ++depth;
        }
        return depth;
    }

    public static String getComponentTypeName(String className) {
        switch (ClassName.getArrayDepth(className)) {
            case 0: {
                return null;
            }
            case 1: {
                return ClassName.getElementTypeName_(className, 1);
            }
        }
        return className.substring(1);
    }

    public static String getSimpleName(String className) {
        return ClassName.isArray(className) ? String.valueOf(ClassName.getSimpleName(ClassName.getComponentTypeName(className))) + "[]" : ClassName.getSimpleName_(className);
    }

    private static String getSimpleName_(String className) {
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        int len = className.length();
        int i = ++index;
        while (i < len) {
            if (!ClassName.charIsAsciiDigit(className.charAt(i))) {
                return className.substring(i);
            }
            ++i;
        }
        return "";
    }

    public static String getPackageName(String className) {
        if (ClassName.isArray(className)) {
            return "";
        }
        int lastPeriod = className.lastIndexOf(46);
        return lastPeriod == -1 ? "" : className.substring(0, lastPeriod);
    }

    public static boolean isTopLevel(String className) {
        if (ClassName.isArray(className)) {
            return false;
        }
        return className.lastIndexOf(36) == -1;
    }

    public static boolean isMember(String className) {
        if (ClassName.isArray(className)) {
            return false;
        }
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return false;
        }
        return !ClassName.charIsAsciiDigit(className.charAt(++index));
    }

    public static boolean isLocal(String className) {
        if (ClassName.isArray(className)) {
            return false;
        }
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return false;
        }
        if (!ClassName.charIsAsciiDigit(className.charAt(++index))) {
            return false;
        }
        int len = className.length();
        int i = ++index;
        while (i < len) {
            if (!ClassName.charIsAsciiDigit(className.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAnonymous(String className) {
        if (ClassName.isArray(className)) {
            return false;
        }
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return false;
        }
        if (!ClassName.charIsAsciiDigit(className.charAt(++index))) {
            return false;
        }
        int len = className.length();
        int i = ++index;
        while (i < len) {
            if (!ClassName.charIsAsciiDigit(className.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean charIsAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isReference(String className) {
        return !ClassName.isPrimitive(className);
    }

    public static boolean isPrimitive(String className) {
        if (ClassName.isArray(className) || className.length() > ReflectionTools.MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            return false;
        }
        for (ReflectionTools.Primitive primitive : ReflectionTools.PRIMITIVES) {
            if (!className.equals(primitive.javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(String className) {
        if (ClassName.isArray(className) || className.length() > ReflectionTools.MAX_PRIMITIVE_WRAPPER_CLASS_NAME_LENGTH) {
            return false;
        }
        for (ReflectionTools.Primitive primitive : ReflectionTools.PRIMITIVES) {
            if (!className.equals(primitive.wrapperClass.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isVariablePrimitive(String className) {
        return ClassName.isPrimitive(className) && !className.equals(VOID_CLASS_NAME);
    }

    public static boolean isVariablePrimitiveWrapper(String className) {
        return ClassName.isPrimitiveWrapper(className) && !className.equals(VOID_WRAPPER_CLASS_NAME);
    }

    public static String getWrapperClassName(String primitiveClassName) {
        for (ReflectionTools.Primitive primitive : ReflectionTools.PRIMITIVES) {
            if (!primitive.javaClass.getName().equals(primitiveClassName)) continue;
            return primitive.wrapperClass.getName();
        }
        return null;
    }

    public static String getPrimitiveClassName(String primitiveWrapperClassName) {
        for (ReflectionTools.Primitive primitive : ReflectionTools.PRIMITIVES) {
            if (!primitive.wrapperClass.getName().equals(primitiveWrapperClassName)) continue;
            return primitive.javaClass.getName();
        }
        return null;
    }

    public static boolean areAutoboxEquivalents(String className1, String className2) {
        return Tools.valuesAreEqual(className1, className2) || Tools.valuesAreEqual(ClassName.getPrimitiveClassName(className1), className2) || Tools.valuesAreEqual(ClassName.getWrapperClassName(className1), className2);
    }

    public static String forCode(int classCode) {
        return ClassName.forCode((char)classCode);
    }

    public static String forCode(char classCode) {
        Class<?> primitiveClass = ReflectionTools.getClassForCode(classCode);
        return primitiveClass == null ? null : primitiveClass.getName();
    }

    public static char getCodeForClassName(String primitiveClassName) {
        if (!ClassName.isArray(primitiveClassName) && primitiveClassName.length() <= ReflectionTools.MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (ReflectionTools.Primitive primitive : ReflectionTools.PRIMITIVES) {
                if (!primitive.javaClass.getName().equals(primitiveClassName)) continue;
                return primitive.code;
            }
        }
        return '\u0000';
    }

    static void append(String className, StringBuilder sb) {
        sb.append('L');
        sb.append(className);
        sb.append(';');
    }

    private ClassName() {
        throw new UnsupportedOperationException();
    }
}

