/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;

public abstract class AbstractListValueModel
extends AbstractModel {
    protected AbstractListValueModel() {
    }

    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addChangeListener(listener);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName.equals("list values") && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName.equals("list values") && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    protected abstract void engageModel();

    protected abstract void disengageModel();
}

