/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.EventListener;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AspectAdapter<S>
extends AbstractModel {
    protected S subject;
    protected final PropertyValueModel<? extends S> subjectHolder;
    protected final PropertyChangeListener subjectChangeListener;

    protected AspectAdapter(S subject) {
        this((PropertyValueModel<S>)new StaticPropertyValueModel<S>(subject));
    }

    protected AspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        if (subjectHolder == null) {
            throw new NullPointerException();
        }
        this.subjectHolder = subjectHolder;
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.subject = null;
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new LocalChangeSupport(this, this.getListenerClass(), this.getListenerAspectName());
    }

    protected PropertyChangeListener buildSubjectChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                AspectAdapter.this.subjectChanged();
            }

            public String toString() {
                return "subject change listener";
            }
        };
    }

    protected synchronized void subjectChanged() {
        Object oldValue = this.getValue();
        boolean hasListeners = this.hasListeners();
        if (hasListeners) {
            this.disengageSubject();
        }
        this.subject = this.subjectHolder.getValue();
        if (hasListeners) {
            this.engageSubject();
            this.fireAspectChanged(oldValue, this.getValue());
        }
    }

    protected abstract Object getValue();

    protected abstract Class<? extends EventListener> getListenerClass();

    protected abstract String getListenerAspectName();

    protected abstract boolean hasListeners();

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected abstract void fireAspectChanged(Object var1, Object var2);

    protected void engageSubject() {
        if (this.subject != null) {
            this.engageSubject_();
        }
    }

    protected abstract void engageSubject_();

    protected void disengageSubject() {
        if (this.subject != null) {
            this.disengageSubject_();
        }
    }

    protected abstract void disengageSubject_();

    protected void engageSubjectHolder() {
        this.subjectHolder.addPropertyChangeListener("value", this.subjectChangeListener);
        this.subject = this.subjectHolder.getValue();
    }

    protected void disengageSubjectHolder() {
        this.subjectHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        this.subject = null;
    }

    protected void engageModels() {
        this.engageSubjectHolder();
        this.engageSubject();
    }

    protected void disengageModels() {
        this.disengageSubject();
        this.disengageSubjectHolder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LocalChangeSupport
    extends SingleAspectChangeSupport {
        private static final long serialVersionUID = 1L;

        public LocalChangeSupport(AspectAdapter<S> source, Class<? extends EventListener> validListenerClass, String validAspectName) {
            super(source, validListenerClass, validAspectName);
        }

        protected boolean hasNoListeners() {
            return this.hasNoListeners(this.validListenerClass, this.validAspectName);
        }

        protected synchronized <T extends EventListener> void addListener(Class<T> listenerClass, T listener) {
            if (this.hasNoListeners()) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(listenerClass, listener);
        }

        protected synchronized <T extends EventListener> void addListener(Class<T> listenerClass, String aspectName, T listener) {
            if (this.hasNoListeners()) {
                AspectAdapter.this.engageModels();
            }
            super.addListener(listenerClass, aspectName, listener);
        }

        protected synchronized <T extends EventListener> void removeListener(Class<T> listenerClass, T listener) {
            super.removeListener(listenerClass, listener);
            if (this.hasNoListeners()) {
                AspectAdapter.this.disengageModels();
            }
        }

        protected synchronized <T extends EventListener> void removeListener(Class<T> listenerClass, String aspectName, T listener) {
            super.removeListener(listenerClass, aspectName, listener);
            if (this.hasNoListeners()) {
                AspectAdapter.this.disengageModels();
            }
        }
    }
}

