/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.common.utility.internal.model.value.AbstractListValueModel;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionListValueModelAdapter<E>
extends AbstractListValueModel
implements ListValueModel<E> {
    protected final CollectionValueModel<? extends E> collectionHolder;
    protected final CollectionChangeListener collectionChangeListener;
    protected final ArrayList<E> list;

    public CollectionListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder) {
        if (collectionHolder == null) {
            throw new NullPointerException();
        }
        this.collectionHolder = collectionHolder;
        this.collectionChangeListener = this.buildCollectionChangeListener();
        this.list = new ArrayList(collectionHolder.size());
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                CollectionListValueModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                CollectionListValueModelAdapter.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                CollectionListValueModelAdapter.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionListValueModelAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator<E>(this.list);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("values", this.collectionChangeListener);
        this.buildList();
    }

    @Override
    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("values", this.collectionChangeListener);
        this.list.clear();
    }

    protected void buildList() {
        int size = this.collectionHolder.size();
        if (size != 0) {
            this.buildList(size);
        }
    }

    protected void buildList(int size) {
        this.list.ensureCapacity(size);
        for (E each : this.collectionHolder) {
            this.list.add(each);
        }
    }

    protected void itemsAdded(CollectionAddEvent event) {
        this.addItemsToList(this.indexToAddItems(), this.getItems(event), this.list, "list values");
    }

    protected int indexToAddItems() {
        return this.list.size();
    }

    protected Iterable<E> getItems(CollectionAddEvent event) {
        return event.getItems();
    }

    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.removeItemsFromList(this.getItems(event), this.list, "list values");
    }

    protected Iterable<E> getItems(CollectionRemoveEvent event) {
        return event.getItems();
    }

    protected void collectionCleared(CollectionClearEvent event) {
        this.clearList(this.list, "list values");
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        int size = this.collectionHolder.size();
        if (size == 0) {
            if (!this.list.isEmpty()) {
                this.clearList(this.list, "list values");
            }
        } else if (this.list.isEmpty()) {
            this.buildList(size);
            this.fireItemsAdded("list values", 0, this.list);
        } else {
            this.synchronizeList(this.buildSyncList(), this.list, "list values");
        }
    }

    protected Iterable<? extends E> buildSyncList() {
        return this.collectionHolder;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.list);
    }
}

