/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

class MultiTermEnum
extends TermEnum {
    private SegmentMergeQueue queue;
    private Term term;
    private int docFreq;

    public MultiTermEnum(IndexReader[] readers, int[] starts, Term t) throws IOException {
        this.queue = new SegmentMergeQueue(readers.length);
        for (int i = 0; i < readers.length; ++i) {
            IndexReader reader = readers[i];
            TermEnum termEnum = t != null ? reader.terms(t) : reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(starts[i], termEnum, reader);
            if (t == null ? smi.next() : termEnum.term() != null) {
                this.queue.put(smi);
                continue;
            }
            smi.close();
        }
        if (t != null && this.queue.size() > 0) {
            this.next();
        }
    }

    public boolean next() throws IOException {
        SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
        if (top == null) {
            this.term = null;
            return false;
        }
        this.term = top.term;
        this.docFreq = 0;
        while (top != null && this.term.compareTo(top.term) == 0) {
            this.queue.pop();
            this.docFreq += top.termEnum.docFreq();
            if (top.next()) {
                this.queue.put(top);
            } else {
                top.close();
            }
            top = (SegmentMergeInfo)this.queue.top();
        }
        return true;
    }

    public Term term() {
        return this.term;
    }

    public int docFreq() {
        return this.docFreq;
    }

    public void close() throws IOException {
        this.queue.close();
    }
}

