/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrmEclipseLinkConverterClassConverter<X extends XmlNamedConverter>
extends OrmEclipseLinkConverter<X>
implements EclipseLinkCustomConverter {
    protected String converterClass;
    protected JavaResourcePersistentType converterPersistentType;

    public OrmEclipseLinkConverterClassConverter(XmlContextNode parent, X xmlConverter) {
        super(parent, xmlConverter);
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    protected void setConverterClass_(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.firePropertyChanged("converterClass", oldConverterClass, newConverterClass);
    }

    protected JavaResourcePersistentType getConverterJavaResourcePersistentType() {
        return this.getEntityMappings().resolveJavaResourcePersistentType(this.converterClass);
    }

    protected void updateConverterPersistentType() {
        this.converterPersistentType = this.getConverterJavaResourcePersistentType();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConverterClass(messages);
    }

    protected void validateConverterClass(List<IMessage> messages) {
        IJavaProject javaProject = this.getJpaProject().getJavaProject();
        if (StringTools.stringIsEmpty((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassExists(javaProject)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_EXISTS", new String[]{this.converterClass}, this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassImplementsInterface(javaProject, "org.eclipse.persistence.mappings.converters.Converter")) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_IMPLEMENTS_CONVERTER", new String[]{this.converterClass}, this, this.getConverterClassTextRange()));
        }
    }

    private boolean converterClassExists(IJavaProject javaProject) {
        if (this.converterClass == null) {
            return false;
        }
        if (JDTTools.findType((IJavaProject)javaProject, (String)this.converterClass) != null) {
            return true;
        }
        String globalPackage = this.getEntityMappings().getPackage();
        if (StringTools.stringIsEmpty((String)globalPackage)) {
            return false;
        }
        return JDTTools.findType((IJavaProject)javaProject, (String)(String.valueOf(globalPackage) + '.' + this.converterClass)) != null;
    }

    private boolean converterClassImplementsInterface(IJavaProject javaProject, String interfaceName) {
        if (this.converterClass == null) {
            return false;
        }
        if (JDTTools.typeNamedImplementsInterfaceNamed((IJavaProject)javaProject, (String)this.converterClass, (String)interfaceName)) {
            return true;
        }
        String globalPackage = this.getEntityMappings().getPackage();
        if (StringTools.stringIsEmpty((String)globalPackage)) {
            return false;
        }
        return JDTTools.typeNamedImplementsInterfaceNamed((IJavaProject)javaProject, (String)(String.valueOf(globalPackage) + '.' + this.converterClass), (String)interfaceName);
    }

    protected TextRange getConverterClassTextRange() {
        return this.getValidationTextRange(this.getXmlConverterClassTextRange());
    }

    protected abstract TextRange getXmlConverterClassTextRange();

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected abstract ReplaceEdit createRenameEdit(IType var1, String var2);

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    protected abstract ReplaceEdit createRenamePackageEdit(String var1);

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.isIn(originalPackage) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected boolean isFor(String typeName) {
        JavaResourcePersistentType converterType = this.getConverterJavaResourcePersistentType();
        return converterType != null && converterType.getQualifiedName().equals(typeName);
    }

    protected boolean isIn(IPackageFragment packageFragment) {
        JavaResourcePersistentType converterType = this.getConverterJavaResourcePersistentType();
        return converterType != null && converterType.isIn(packageFragment);
    }
}

