/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.NullEclipseLinkWriteTransformerColumnAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.SourceEclipseLinkTransformerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkWriteTransformerAnnotation;

public final class SourceEclipseLinkWriteTransformerAnnotation
extends SourceEclipseLinkTransformerAnnotation
implements EclipseLinkWriteTransformerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.WriteTransformer");
    private final ElementAnnotationAdapter columnAdapter;
    private ColumnAnnotation column;
    private final ColumnAnnotation nullColumn;

    public SourceEclipseLinkWriteTransformerAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.columnAdapter = new ElementAnnotationAdapter(this.annotatedElement, SourceEclipseLinkWriteTransformerAnnotation.buildColumnAnnotationAdapter(this.daa));
        this.nullColumn = this.buildNullColumn();
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.WriteTransformer";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = SourceEclipseLinkWriteTransformerAnnotation.createColumn((JavaResourceNode)this, (Member)this.annotatedElement, this.daa);
            this.column.initialize(astRoot);
        }
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncColumn(astRoot);
    }

    public boolean isUnset() {
        return super.isUnset() && this.column == null;
    }

    String getTransformerClassElementName() {
        return "transformerClass";
    }

    String getMethodElementName() {
        return "method";
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : this.nullColumn;
    }

    public ColumnAnnotation addColumn() {
        if (this.column != null) {
            throw new IllegalStateException("'column' element already exists: " + this.column);
        }
        this.column = SourceEclipseLinkWriteTransformerAnnotation.createColumn((JavaResourceNode)this, (Member)this.annotatedElement, this.daa);
        this.column.newAnnotation();
        return this.column;
    }

    public void removeColumn() {
        if (this.column == null) {
            throw new IllegalStateException("'column' element does not exist");
        }
        ColumnAnnotation old = this.column;
        this.column = null;
        old.removeAnnotation();
    }

    private void syncColumn(CompilationUnit astRoot) {
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.syncColumn_(null);
        } else if (this.column == null) {
            ColumnAnnotation col = SourceEclipseLinkWriteTransformerAnnotation.createColumn((JavaResourceNode)this, (Member)this.annotatedElement, this.daa);
            col.initialize(astRoot);
            this.syncColumn_(col);
        } else {
            this.column.synchronizeWith(astRoot);
        }
    }

    private void syncColumn_(ColumnAnnotation astColumn) {
        ColumnAnnotation old = this.column;
        this.column = astColumn;
        this.firePropertyChanged("column", old, astColumn);
    }

    private ColumnAnnotation buildNullColumn() {
        return new NullEclipseLinkWriteTransformerColumnAnnotation(this);
    }

    public TextRange getColumnTextRange(CompilationUnit astRoot) {
        if (this.column != null) {
            return this.column.getTextRange(astRoot);
        }
        return this.getTextRange(astRoot);
    }

    private static DeclarationAnnotationAdapter buildColumnAnnotationAdapter(DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(writeTransformerAnnotationAdapter, "column", "javax.persistence.Column");
    }

    private static ColumnAnnotation createColumn(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new SourceColumnAnnotation(parent, member, SourceEclipseLinkWriteTransformerAnnotation.buildColumnAnnotationAdapter(writeTransformerAnnotationAdapter));
    }
}

