/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.data.ITaskAttributeDiff;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskAttributeDiff
implements ITaskAttributeDiff {
    private String attributeId;
    private final TaskAttribute newAttribute;
    private final List<String> newValues;
    private final TaskAttribute oldAttribute;
    private final List<String> oldValues;

    public TaskAttributeDiff(TaskAttribute oldAttribute, TaskAttribute newAttribute) {
        Assert.isTrue((oldAttribute != null || newAttribute != null ? 1 : 0) != 0);
        this.oldAttribute = oldAttribute;
        this.newAttribute = newAttribute;
        if (oldAttribute != null) {
            this.oldValues = oldAttribute.getTaskData().getAttributeMapper().getValueLabels(oldAttribute);
            this.attributeId = oldAttribute.getId();
        } else {
            this.oldValues = Collections.emptyList();
        }
        if (newAttribute != null) {
            this.newValues = newAttribute.getTaskData().getAttributeMapper().getValueLabels(newAttribute);
            this.attributeId = newAttribute.getId();
        } else {
            this.newValues = Collections.emptyList();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAttributeDiff other = (TaskAttributeDiff)obj;
        return !(this.attributeId == null ? other.attributeId != null : !this.attributeId.equals(other.attributeId));
    }

    public List<String> getAddedValues() {
        ArrayList<String> result = new ArrayList<String>(this.getNewValues());
        if (this.getOldValues() != null) {
            result.removeAll(this.getOldValues());
        }
        return result;
    }

    public TaskAttribute getNewAttribute() {
        return this.newAttribute;
    }

    public List<String> getNewValues() {
        return this.newValues;
    }

    public TaskAttribute getOldAttribute() {
        return this.oldAttribute;
    }

    public List<String> getOldValues() {
        return this.oldValues;
    }

    public List<String> getRemovedValues() {
        ArrayList<String> result = new ArrayList<String>(this.getOldValues());
        if (this.getNewValues() != null) {
            result.removeAll(this.getNewValues());
        }
        return result;
    }

    public boolean hasChanges() {
        return !this.oldValues.equals(this.newValues);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributeId == null ? 0 : this.attributeId.hashCode());
        return result;
    }

    public String getLabel() {
        if (this.newAttribute != null) {
            return this.newAttribute.getTaskData().getAttributeMapper().getLabel(this.newAttribute);
        }
        return this.oldAttribute.getTaskData().getAttributeMapper().getLabel(this.oldAttribute);
    }

    @Override
    public String getAttributeId() {
        return this.attributeId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskAttributeDiff [attributeId=");
        builder.append(this.attributeId);
        builder.append(", newAttribute=");
        builder.append(this.newAttribute);
        builder.append(", oldAttribute=");
        builder.append(this.oldAttribute);
        builder.append("]");
        return builder.toString();
    }
}

