/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataExternalizer;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.xml.sax.SAXException;

public class TaskDataStore {
    private static final String FILE_NAME_INTERNAL = "data.xml";
    private final TaskDataExternalizer externalizer;

    public TaskDataStore(IRepositoryManager taskRepositoryManager) {
        this.externalizer = new TaskDataExternalizer(taskRepositoryManager);
    }

    public synchronized TaskDataState discardEdits(File file) throws CoreException {
        TaskDataState state = this.readState(file);
        if (state != null) {
            state.setEditsData(null);
        }
        this.writeState(file, state);
        return state;
    }

    public synchronized TaskDataState getTaskDataState(File file) throws CoreException {
        return this.readState(file);
    }

    public synchronized void putEdits(File file, TaskData data) throws CoreException {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)data);
        TaskDataState state = this.readState(file);
        if (state == null) {
            state = new TaskDataState(data.getConnectorKind(), data.getRepositoryUrl(), data.getTaskId());
        }
        state.setEditsData(data);
        this.writeState(file, state);
    }

    public synchronized TaskDataState putTaskData(File file, TaskData data, boolean setLastRead, boolean user) throws CoreException {
        TaskDataState state;
        block4: {
            Assert.isNotNull((Object)file);
            Assert.isNotNull((Object)data);
            state = null;
            try {
                state = this.readState(file);
            }
            catch (CoreException e) {
                if (user) break block4;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Reading of existing task data failed. Forcing synchronization will override outgoing changes.", (Throwable)e));
            }
        }
        if (state == null) {
            state = new TaskDataState(data.getConnectorKind(), data.getRepositoryUrl(), data.getTaskId());
        }
        if (setLastRead) {
            state.setLastReadData(state.getRepositoryData());
        }
        state.setRepositoryData(data);
        this.writeState(file, state);
        return state;
    }

    public synchronized TaskDataState setTaskData(File file, TaskData data) throws CoreException {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)data);
        TaskDataState state = new TaskDataState(data.getConnectorKind(), data.getRepositoryUrl(), data.getTaskId());
        state.setRepositoryData(data);
        state.setEditsData(null);
        state.setLastReadData(data);
        this.writeState(file, state);
        return state;
    }

    private TaskDataState readStateInternal(File file, boolean xml11) throws IOException, SAXException {
        ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            in.getNextEntry();
            if (xml11) {
                TaskDataState taskDataState = this.externalizer.readState(new TaskDataExternalizer.Xml11InputStream(in));
                return taskDataState;
            }
            TaskDataState taskDataState = this.externalizer.readState(in);
            return taskDataState;
        }
        finally {
            in.close();
        }
    }

    private TaskDataState readState(File file) throws CoreException {
        try {
            if (file.exists()) {
                try {
                    return this.readStateInternal(file, false);
                }
                catch (SAXException e) {
                    try {
                        if (e.getMessage() != null && e.getMessage().contains("invalid XML character")) {
                            return this.readStateInternal(file, true);
                        }
                        throw e;
                    }
                    catch (SAXException e2) {
                        throw new IOException("Error parsing task data: " + e2.getMessage());
                    }
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error reading task data", (Throwable)e));
        }
    }

    private void writeState(File file, TaskDataState state) throws CoreException {
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.setMethod(8);
                ZipEntry entry = new ZipEntry(FILE_NAME_INTERNAL);
                out.putNextEntry(entry);
                this.externalizer.writeState(out, state);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error writing task data", (Throwable)e));
        }
    }

    public synchronized void putTaskData(File file, TaskDataState state) throws CoreException {
        this.writeState(file, state);
    }

    public synchronized boolean deleteTaskData(File file) {
        return file.delete();
    }
}

