/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.model;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.Messages;
import org.eclipse.mylyn.internal.discovery.core.util.WebUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryFeedbackJob
extends Job {
    private final List<ConnectorDescriptor> descriptors;

    private static String toUrl(Map<String, String> p) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : p.entrySet()) {
            if (entry.getValue() == null) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return sb.toString();
    }

    private static String getBundleVersion(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Object bundleVersion = bundle.getHeaders().get("Bundle-Version");
        if (bundleVersion == null) {
            return null;
        }
        return DiscoveryFeedbackJob.stripQualifier((String)bundleVersion);
    }

    private static Map<String, String> getProperties(ConnectorDescriptor descriptor) {
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        p.put("id", descriptor.getId());
        p.put("discovery", DiscoveryFeedbackJob.getBundleVersion(Platform.getBundle((String)"org.eclipse.mylyn")));
        p.put("product", System.getProperty("eclipse.product"));
        p.put("buildId", System.getProperty("eclipse.buildId"));
        p.put("os", System.getProperty("osgi.os"));
        p.put("arch", System.getProperty("osgi.arch"));
        p.put("ws", System.getProperty("osgi.ws"));
        p.put("nl", System.getProperty("osgi.nl"));
        return p;
    }

    private static String stripQualifier(String longVersion) {
        if (longVersion == null) {
            return null;
        }
        String[] parts = longVersion.split("\\.");
        StringBuilder version = new StringBuilder();
        if (parts.length > 0) {
            version.append(parts[0]);
            if (parts.length > 1) {
                version.append(".");
                version.append(parts[1]);
                if (parts.length > 2) {
                    version.append(".");
                    version.append(parts[2]);
                }
            }
        }
        return version.toString();
    }

    public DiscoveryFeedbackJob(List<ConnectorDescriptor> descriptors) {
        super(Messages.DiscoveryFeedbackJob_Job_Label);
        Assert.isNotNull(descriptors);
        this.descriptors = descriptors;
        this.setSystem(true);
    }

    private List<URI> getStatUrls() {
        ArrayList<URI> uris = new ArrayList<URI>(this.descriptors.size());
        for (ConnectorDescriptor descriptor : this.descriptors) {
            try {
                StringBuilder sb = new StringBuilder(descriptor.getStatsUrl());
                try {
                    Map<String, String> p = DiscoveryFeedbackJob.getProperties(descriptor);
                    String parameters = DiscoveryFeedbackJob.toUrl(p);
                    sb.append("?");
                    sb.append(parameters);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                URI uri = new URI(sb.toString());
                uris.add(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return uris;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            WebUtil.verifyAvailability(this.getStatUrls(), false, monitor);
        }
        catch (Exception exception) {}
        return Status.OK_STATUS;
    }
}

